<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <?php include 'winTab.php' ?>
    <title>Our Services</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        :root {
            --primary: #3b82f6;
            --secondary: #1e40af;
            --accent: #60a5fa;
            --dark: #0f172a;
            --darker: #020617;
            --light: #f8fafc;
            --text: #cbd5e1;
            --text-dark: #94a3b8;
            --success: #10b981;
            --card-bg: #1e293b;
        }

        body {
            background: linear-gradient(135deg, var(--darker), var(--dark));
            color: var(--text);
            line-height: 1.6;
            overflow-x: hidden;
        }

        .container {
            width: 90%;
            max-width: 1200px;
            margin: 0 auto;
        }

        /* Header & Navigation */
        header {
            background: rgba(15, 23, 42, 0.95);
            color: white;
            padding: 1rem 0;
            position: sticky;
            top: 0;
            z-index: 1000;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
            backdrop-filter: blur(10px);
        }

        .navbar {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .logo {
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 1.8rem;
            font-weight: 700;
            animation: fadeIn 1s ease;
        }

        .logo i {
            color: #fbbf24;
        }

        .nav-links {
            display: flex;
            list-style: none;
            gap: 2rem;
        }

        .nav-links a {
            color: var(--text);
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s ease;
            position: relative;
        }

        .nav-links a:hover {
            color: #fbbf24;
        }

        .nav-links a::after {
            content: '';
            position: absolute;
            bottom: -5px;
            left: 0;
            width: 0;
            height: 2px;
            background-color: #fbbf24;
            transition: width 0.3s ease;
        }

        .nav-links a:hover::after {
            width: 100%;
        }

        .auth-buttons {
            display: flex;
            gap: 1rem;
        }

        .btn {
            padding: 0.6rem 1.5rem;
            border-radius: 50px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            border: none;
        }

        .btn-login {
            background: transparent;
            color: white;
            border: 2px solid var(--primary);
        }

        .btn-login:hover {
            background: var(--primary);
            color: white;
        }

        .btn-signup {
            background: #fbbf24;
            color: var(--dark);
        }

        .btn-signup:hover {
            background: #f59e0b;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(245, 158, 11, 0.4);
        }

        /* Hero Section */
        .hero {
            background: linear-gradient(rgba(15, 23, 42, 0.85), rgba(2, 6, 23, 0.9)), url('https://images.unsplash.com/photo-1581094794329-c8112a89af12?ixlib=rb-4.0.3&auto=format&fit=crop&w=1950&q=80');
            background-size: cover;
            background-position: center;
            color: white;
            padding: 6rem 0;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .hero-content {
            max-width: 800px;
            margin: 0 auto;
            animation: slideUp 1s ease;
        }

        .hero h1 {
            font-size: 3.5rem;
            margin-bottom: 1.5rem;
            line-height: 1.2;
            text-shadow: 0 2px 10px rgba(0, 0, 0, 0.3);
        }

        .hero p {
            font-size: 1.2rem;
            margin-bottom: 2rem;
            opacity: 0.9;
        }

        /* Services Section */
        .services {
            padding: 5rem 0;
            background: var(--darker);
        }

        .section-title {
            text-align: center;
            margin-bottom: 3rem;
        }

        .section-title h2 {
            font-size: 2.5rem;
            color: white;
            margin-bottom: 1rem;
            position: relative;
            display: inline-block;
        }

        .section-title h2::after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 4px;
            background: var(--primary);
            border-radius: 2px;
        }

        .section-title p {
            max-width: 700px;
            margin: 0 auto;
            color: var(--text);
        }

        .services-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
            gap: 2rem;
        }

        .service-card {
            background: var(--card-bg);
            border-radius: 10px;
            padding: 2.5rem 2rem;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            transition: all 0.3s ease;
            cursor: pointer;
            border: 1px solid rgba(255, 255, 255, 0.05);
            position: relative;
            overflow: hidden;
        }

        .service-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 4px;
            background: var(--primary);
            transform: scaleX(0);
            transition: transform 0.3s ease;
        }

        .service-card:hover::before {
            transform: scaleX(1);
        }

        .service-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.3);
        }

        .service-icon {
            width: 80px;
            height: 80px;
            background: rgba(59, 130, 246, 0.1);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.5rem;
            font-size: 2rem;
            color: var(--primary);
        }

        .service-card h3 {
            margin-bottom: 1rem;
            color: white;
            font-size: 1.5rem;
        }

        .service-card p {
            color: var(--text);
            margin-bottom: 1.5rem;
        }

        .service-features {
            list-style: none;
            text-align: left;
            margin-bottom: 2rem;
        }

        .service-features li {
            margin-bottom: 0.8rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .service-features li i {
            color: var(--success);
            font-size: 0.9rem;
        }

        .btn-service {
            background: var(--primary);
            color: white;
            border: none;
            padding: 0.8rem 1.8rem;
            border-radius: 50px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }

        .btn-service:hover {
            background: var(--secondary);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(59, 130, 246, 0.4);
        }

        /* How It Works Section */
        .how-it-works {
            padding: 5rem 0;
            background: var(--dark);
        }

        .steps-container {
            display: flex;
            justify-content: space-between;
            gap: 2rem;
            margin-top: 3rem;
            position: relative;
        }

        .steps-container::before {
            content: '';
            position: absolute;
            top: 80px;
            left: 10%;
            width: 80%;
            height: 3px;
            background: var(--primary);
            z-index: 1;
        }

        .step {
            text-align: center;
            position: relative;
            z-index: 2;
            flex: 1;
        }

        .step-number {
            width: 60px;
            height: 60px;
            background: var(--primary);
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            font-weight: 700;
            margin: 0 auto 1.5rem;
            box-shadow: 0 5px 15px rgba(59, 130, 246, 0.4);
        }

        .step h3 {
            margin-bottom: 1rem;
            color: white;
        }

        .step p {
            color: var(--text);
        }

        /* Testimonials Section */
        .testimonials {
            padding: 5rem 0;
            background: var(--darker);
        }

        .testimonials-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 2rem;
            margin-top: 3rem;
        }

        .testimonial-card {
            background: var(--card-bg);
            border-radius: 10px;
            padding: 2rem;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.05);
            position: relative;
        }

        .testimonial-card::before {
            content: '\201C';
            position: absolute;
            top: 10px;
            left: 20px;
            font-size: 4rem;
            color: rgba(255, 255, 255, 0.1);
            font-family: Georgia, serif;
        }

        .testimonial-text {
            margin-bottom: 1.5rem;
            font-style: italic;
            position: relative;
            z-index: 2;
        }

        .testimonial-author {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .author-avatar {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            overflow: hidden;
        }

        .author-avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .author-info h4 {
            color: white;
            margin-bottom: 0.3rem;
        }

        .author-info p {
            color: var(--text-dark);
            font-size: 0.9rem;
        }

        /* Pricing Section */
        .pricing {
            padding: 5rem 0;
            background: var(--dark);
        }

        .pricing-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 2rem;
            margin-top: 3rem;
        }

        .pricing-card {
            background: var(--card-bg);
            border-radius: 10px;
            padding: 2.5rem 2rem;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.05);
            transition: all 0.3s ease;
            position: relative;
        }

        .pricing-card.featured {
            border: 2px solid var(--primary);
            transform: scale(1.05);
        }

        .pricing-card.featured::before {
            content: 'Most Popular';
            position: absolute;
            top: -12px;
            left: 50%;
            transform: translateX(-50%);
            background: var(--primary);
            color: white;
            padding: 0.3rem 1.5rem;
            border-radius: 50px;
            font-size: 0.8rem;
            font-weight: 600;
        }

        .pricing-header {
            margin-bottom: 2rem;
        }

        .pricing-name {
            font-size: 1.5rem;
            color: white;
            margin-bottom: 1rem;
        }

        .pricing-price {
            font-size: 2.5rem;
            color: white;
            margin-bottom: 0.5rem;
        }

        .pricing-price span {
            font-size: 1rem;
            color: var(--text-dark);
        }

        .pricing-desc {
            color: var(--text);
            margin-bottom: 2rem;
        }

        .pricing-features {
            list-style: none;
            margin-bottom: 2rem;
            text-align: left;
        }

        .pricing-features li {
            margin-bottom: 0.8rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .pricing-features li i {
            color: var(--success);
        }

        .btn-pricing {
            width: 100%;
            background: var(--primary);
            color: white;
            border: none;
            padding: 1rem;
            border-radius: 50px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .btn-pricing:hover {
            background: var(--secondary);
        }

        /* CTA Section */
        .cta {
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            color: white;
            padding: 5rem 0;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .cta::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: url('https://images.unsplash.com/photo-1552664730-d307ca884978?ixlib=rb-4.0.3&auto=format&fit=crop&w=1000&q=80');
            background-size: cover;
            background-position: center;
            opacity: 0.1;
        }

        .cta h2 {
            font-size: 2.5rem;
            margin-bottom: 1.5rem;
            position: relative;
        }

        .cta p {
            max-width: 700px;
            margin: 0 auto 2rem;
            font-size: 1.1rem;
            position: relative;
        }

        .btn-cta {
            background: #fbbf24;
            color: var(--dark);
            padding: 1rem 2.5rem;
            font-size: 1.1rem;
            border-radius: 50px;
            display: inline-block;
            transition: all 0.3s ease;
            position: relative;
            font-weight: 600;
            text-decoration: none;
        }

        .btn-cta:hover {
            background: #f59e0b;
            transform: translateY(-3px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
        }

        /* Footer */
        footer {
            background: var(--darker);
            color: white;
            padding: 4rem 0 2rem;
            border-top: 1px solid rgba(255, 255, 255, 0.05);
        }

        .footer-content {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 3rem;
            margin-bottom: 3rem;
        }

        .footer-column h3 {
            font-size: 1.3rem;
            margin-bottom: 1.5rem;
            position: relative;
            padding-bottom: 10px;
            color: white;
        }

        .footer-column h3::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 40px;
            height: 3px;
            background: var(--primary);
        }

        .footer-links {
            list-style: none;
        }

        .footer-links li {
            margin-bottom: 0.8rem;
        }

        .footer-links a {
            color: var(--text-dark);
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .footer-links a:hover {
            color: white;
            padding-left: 5px;
        }

        .social-links {
            display: flex;
            gap: 1rem;
            margin-top: 1.5rem;
        }

        .social-links a {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.05);
            border-radius: 50%;
            color: var(--text);
            transition: all 0.3s ease;
        }

        .social-links a:hover {
            background: var(--primary);
            color: white;
            transform: translateY(-3px);
        }

        .footer-bottom {
            text-align: center;
            padding-top: 2rem;
            border-top: 1px solid rgba(255, 255, 255, 0.05);
            color: var(--text-dark);
            font-size: 0.9rem;
        }

        /* Animations */
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        @keyframes slideUp {
            from { 
                opacity: 0;
                transform: translateY(30px);
            }
            to { 
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes float {
            0% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
            100% { transform: translateY(0px); }
        }

        /* Responsive Design */
        @media (max-width: 992px) {
            .steps-container {
                flex-direction: column;
                gap: 3rem;
            }
            
            .steps-container::before {
                display: none;
            }
            
            .hero h1 {
                font-size: 2.8rem;
            }
        }

        @media (max-width: 768px) {
            .navbar {
                flex-direction: column;
                gap: 1rem;
            }
            
            .nav-links {
                gap: 1rem;
                flex-wrap: wrap;
                justify-content: center;
            }
            
            .hero h1 {
                font-size: 2.2rem;
            }
            
            .services-grid, .testimonials-grid, .pricing-grid {
                grid-template-columns: 1fr;
            }
            
            .pricing-card.featured {
                transform: scale(1);
            }
        }
    </style>
</head>
<body>
    <!-- Header -->
    <?php include  "header.php" ?>

    <!-- Hero Section -->
    <section class="hero">
        <div class="container">
            <div class="hero-content">
                <h1>Our Professional Services</h1>
                <p>CareerConnect offers comprehensive solutions for job seekers and employers to connect, collaborate, and achieve career success.</p>
            </div>
        </div>
    </section>

    <!-- Services Section -->
    <section class="services">
        <div class="container">
            <div class="section-title">
                <h2>Our Services</h2>
                <p>We provide a wide range of services designed to help both job seekers and employers find the perfect match.</p>
            </div>
            <div class="services-grid">
                <div class="service-card">
                    <div class="service-icon">
                        <i class="fas fa-search"></i>
                    </div>
                    <h3>Job Matching</h3>
                    <p>Our advanced algorithm matches your skills, experience, and preferences with the perfect job opportunities.</p>
                    <ul class="service-features">
                        <li><i class="fas fa-check"></i> Personalized job recommendations</li>
                        <li><i class="fas fa-check"></i> Skill-based matching</li>
                        <li><i class="fas fa-check"></i> Location preferences</li>
                        <li><i class="fas fa-check"></i> Salary expectations alignment</li>
                    </ul>
                    <button class="btn-service">Learn More <i class="fas fa-arrow-right"></i></button>
                </div>
                
                <div class="service-card">
                    <div class="service-icon">
                        <i class="fas fa-file-alt"></i>
                    </div>
                    <h3>Resume Building</h3>
                    <p>Create professional, ATS-friendly resumes that stand out to employers and recruiters.</p>
                    <ul class="service-features">
                        <li><i class="fas fa-check"></i> Professional templates</li>
                        <li><i class="fas fa-check"></i> ATS optimization</li>
                        <li><i class="fas fa-check"></i> Expert review services</li>
                        <li><i class="fas fa-check"></i> Industry-specific formatting</li>
                    </ul>
                    <button class="btn-service">Learn More <i class="fas fa-arrow-right"></i></button>
                </div>
                
                <div class="service-card">
                    <div class="service-icon">
                        <i class="fas fa-user-tie"></i>
                    </div>
                    <h3>Career Coaching</h3>
                    <p>One-on-one sessions with experienced career coaches to guide your professional journey.</p>
                    <ul class="service-features">
                        <li><i class="fas fa-check"></i> Personalized career planning</li>
                        <li><i class="fas fa-check"></i> Interview preparation</li>
                        <li><i class="fas fa-check"></i> Salary negotiation strategies</li>
                        <li><i class="fas fa-check"></i> Career transition support</li>
                    </ul>
                    <button class="btn-service">Learn More <i class="fas fa-arrow-right"></i></button>
                </div>
                
                <div class="service-card">
                    <div class="service-icon">
                        <i class="fas fa-briefcase"></i>
                    </div>
                    <h3>Recruitment Solutions</h3>
                    <p>Comprehensive hiring solutions for businesses of all sizes to find the right talent.</p>
                    <ul class="service-features">
                        <li><i class="fas fa-check"></i> Candidate screening</li>
                        <li><i class="fas fa-check"></i> Job posting optimization</li>
                        <li><i class="fas fa-check"></i> Employer branding</li>
                        <li><i class="fas fa-check"></i> Talent pipeline development</li>
                    </ul>
                    <button class="btn-service">Learn More <i class="fas fa-arrow-right"></i></button>
                </div>
                
                <div class="service-card">
                    <div class="service-icon">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <h3>Skill Assessment</h3>
                    <p>Evaluate and validate your skills with our comprehensive assessment tools.</p>
                    <ul class="service-features">
                        <li><i class="fas fa-check"></i> Technical skill tests</li>
                        <li><i class="fas fa-check"></i> Soft skills evaluation</li>
                        <li><i class="fas fa-check"></i> Certification programs</li>
                        <li><i class="fas fa-check"></i> Skill gap analysis</li>
                    </ul>
                    <button class="btn-service">Learn More <i class="fas fa-arrow-right"></i></button>
                </div>
                
                <div class="service-card">
                    <div class="service-icon">
                        <i class="fas fa-network-wired"></i>
                    </div>
                    <h3>Networking Events</h3>
                    <p>Connect with industry professionals and expand your professional network.</p>
                    <ul class="service-features">
                        <li><i class="fas fa-check"></i> Virtual career fairs</li>
                        <li><i class="fas fa-check"></i> Industry-specific meetups</li>
                        <li><i class="fas fa-check"></i> Professional workshops</li>
                        <li><i class="fas fa-check"></i> Mentorship programs</li>
                    </ul>
                    <button class="btn-service">Learn More <i class="fas fa-arrow-right"></i></button>
                </div>
            </div>
        </div>
    </section>

    <!-- How It Works Section -->
    <section class="how-it-works">
        <div class="container">
            <div class="section-title">
                <h2>How It Works</h2>
                <p>Our simple 4-step process to connect job seekers with their dream careers.</p>
            </div>
            <div class="steps-container">
                <div class="step">
                    <div class="step-number">1</div>
                    <h3>Create Profile</h3>
                    <p>Sign up and build your professional profile with skills, experience, and career goals.</p>
                </div>
                <div class="step">
                    <div class="step-number">2</div>
                    <h3>Find Opportunities</h3>
                    <p>Browse through thousands of job listings or let our algorithm recommend the best matches.</p>
                </div>
                <div class="step">
                    <div class="step-number">3</div>
                    <h3>Apply & Connect</h3>
                    <p>Apply to positions directly and connect with hiring managers and recruiters.</p>
                </div>
                <div class="step">
                    <div class="step-number">4</div>
                    <h3>Get Hired</h3>
                    <p>Interview, negotiate, and secure your next career opportunity with our support.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Testimonials Section -->
    <section class="testimonials">
        <div class="container">
            <div class="section-title">
                <h2>Success Stories</h2>
                <p>Hear from professionals who found their dream jobs through CareerConnect.</p>
            </div>
            <div class="testimonials-grid">
                <div class="testimonial-card">
                    <div class="testimonial-text">
                        "CareerConnect helped me transition from retail management to a cybersecurity role. Their career coaching and resume services were invaluable!"
                    </div>
                    <div class="testimonial-author">
                        <div class="author-avatar">
                            <img src="https://randomuser.me/api/portraits/women/44.jpg" alt="Sarah Johnson">
                        </div>
                        <div class="author-info">
                            <h4>Sarah Johnson</h4>
                            <p>Cybersecurity Analyst</p>
                        </div>
                    </div>
                </div>
                
                <div class="testimonial-card">
                    <div class="testimonial-text">
                        "As a hiring manager, CareerConnect has streamlined our recruitment process. The quality of candidates is consistently excellent."
                    </div>
                    <div class="testimonial-author">
                        <div class="author-avatar">
                            <img src="https://randomuser.me/api/portraits/men/32.jpg" alt="Michael Chen">
                        </div>
                        <div class="author-info">
                            <h4>Michael Chen</h4>
                            <p>HR Director, TechSolutions Inc.</p>
                        </div>
                    </div>
                </div>
                
                <div class="testimonial-card">
                    <div class="testimonial-text">
                        "I landed my dream remote developer job in just 3 weeks using CareerConnect. The skill assessment helped me showcase my abilities effectively."
                    </div>
                    <div class="testimonial-author">
                        <div class="author-avatar">
                            <img src="https://randomuser.me/api/portraits/women/68.jpg" alt="Jessica Martinez">
                        </div>
                        <div class="author-info">
                            <h4>Jessica Martinez</h4>
                            <p>Full Stack Developer</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Pricing Section -->
    <section class="pricing">
        <div class="container">
            <div class="section-title">
                <h2>Pricing Plans</h2>
                <p>Choose the plan that works best for your career needs.</p>
            </div>
            <div class="pricing-grid">
                <div class="pricing-card">
                    <div class="pricing-header">
                        <h3 class="pricing-name">Basic</h3>
                        <div class="pricing-price">$0<span>/month</span></div>
                        <p class="pricing-desc">Perfect for getting started</p>
                    </div>
                    <ul class="pricing-features">
                        <li><i class="fas fa-check"></i> Basic job search</li>
                        <li><i class="fas fa-check"></i> Limited job applications</li>
                        <li><i class="fas fa-check"></i> Standard resume template</li>
                        <li><i class="fas fa-times"></i> Career coaching</li>
                        <li><i class="fas fa-times"></i> Skill assessments</li>
                    </ul>
                    <button class="btn-pricing">Get Started</button>
                </div>
                
                <div class="pricing-card featured">
                    <div class="pricing-header">
                        <h3 class="pricing-name">Professional</h3>
                        <div class="pricing-price">$29<span>/month</span></div>
                        <p class="pricing-desc">Our most popular plan</p>
                    </div>
                    <ul class="pricing-features">
                        <li><i class="fas fa-check"></i> Unlimited job applications</li>
                        <li><i class="fas fa-check"></i> Advanced job matching</li>
                        <li><i class="fas fa-check"></i> Premium resume templates</li>
                        <li><i class="fas fa-check"></i> 2 career coaching sessions</li>
                        <li><i class="fas fa-check"></i> Full skill assessments</li>
                    </ul>
                    <button class="btn-pricing">Get Started</button>
                </div>
                
                <div class="pricing-card">
                    <div class="pricing-header">
                        <h3 class="pricing-name">Enterprise</h3>
                        <div class="pricing-price">$79<span>/month</span></div>
                        <p class="pricing-desc">For serious job seekers</p>
                    </div>
                    <ul class="pricing-features">
                        <li><i class="fas fa-check"></i> Priority job matching</li>
                        <li><i class="fas fa-check"></i> Executive resume services</li>
                        <li><i class="fas fa-check"></i> Unlimited career coaching</li>
                        <li><i class="fas fa-check"></i> Direct recruiter access</li>
                        <li><i class="fas fa-check"></i> Interview guarantee</li>
                    </ul>
                    <button class="btn-pricing">Get Started</button>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta">
        <div class="container">
            <h2>Ready to Advance Your Career?</h2>
            <p>Join thousands of professionals who have found their dream jobs through CareerConnect. Choose a plan and get started today!</p>
            <a href="#" class="btn btn-cta">Get Started Now</a>
        </div>
    </section>

    <!-- Footer -->
    <footer>
        <div class="container">
            <div class="footer-content">
                <div class="footer-column">
                    <h3>CareerConnect</h3>
                    <p>Connecting talent with opportunity. We're dedicated to helping you find the perfect job match.</p>
                    <div class="social-links">
                        <a href="#"><i class="fab fa-facebook-f"></i></a>
                        <a href="#"><i class="fab fa-twitter"></i></a>
                        <a href="#"><i class="fab fa-linkedin-in"></i></a>
                        <a href="#"><i class="fab fa-instagram"></i></a>
                    </div>
                </div>
                <div class="footer-column">
                    <h3>Quick Links</h3>
                    <ul class="footer-links">
                        <li><a href="index.php">Home</a></li>
                        <li><a href="about.php">About Us</a></li>
                        <li><a href="servcies.php">Services</a></li>
                        <li><a href="joblist.php">Job List</a></li>
                        <li><a href="contact.php">contact s</a></li>
                    </ul>
                </div>
                <div class="footer-column">
                    <h3>Services</h3>
                    <ul class="footer-links">
                        <li><a href="#">Job Matching</a></li>
                        <li><a href="#">Resume Building</a></li>
                        <li><a href="#">Career Coaching</a></li>
                        <li><a href="#">Recruitment Solutions</a></li>
                        <li><a href="#">Skill Assessment</a></li>
                    </ul>
                </div>
                <div class="footer-column">
                    <h3>Contact Us</h3>
                    <ul class="footer-links">
                        <li><i class="fas fa-map-marker-alt"></i> 123 Business Ave, City</li>
                        <li><i class="fas fa-phone"></i> +1 (555) 123-4567</li>
                        <li><i class="fas fa-envelope"></i> info@careerconnect.com</li>
                    </ul>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; 2023 CareerConnect. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <script>
        // Simple animation on scroll
        document.addEventListener('DOMContentLoaded', function() {
            const animatedElements = document.querySelectorAll('.service-card, .step, .testimonial-card, .pricing-card');
            
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.style.opacity = '1';
                        entry.target.style.transform = 'translateY(0)';
                    }
                });
            }, { threshold: 0.1 });
            
            animatedElements.forEach(el => {
                el.style.opacity = '0';
                el.style.transform = 'translateY(20px)';
                el.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
                observer.observe(el);
            });

            // Service button functionality
            const serviceButtons = document.querySelectorAll('.btn-service');
            serviceButtons.forEach(button => {
                button.addEventListener('click', () => {
                    const serviceName = button.closest('.service-card').querySelector('h3').textContent;
                    alert(`Thank you for your interest in our ${serviceName} service! Our team will contact you shortly with more information.`);
                });
            });

            // Pricing button functionality
            const pricingButtons = document.querySelectorAll('.btn-pricing');
            pricingButtons.forEach(button => {
                button.addEventListener('click', () => {
                    const planName = button.closest('.pricing-card').querySelector('.pricing-name').textContent;
                    alert(`You've selected the ${planName} plan. You'll be redirected to the registration page.`);
                });
            });
        });
    </script>
</body>
</html>