<?php
// login.php
session_start();

require_once 'connection.php'; // include your PDO connection file

// ✅ Ensure you have a $conn (PDO)
$conn = Database::connect();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    if (!$email || !$password) {
        $_SESSION['error'] = "Please enter both email and password.";
        header('Location: login.php');
        exit;
    }

    $stmt = $conn->prepare("SELECT * FROM signin WHERE email = :email LIMIT 1");
    $stmt->execute([':email' => $email]);
    $user = $stmt->fetch();

    if (!$user) {
        $_SESSION['error'] = "Email not found.";
        header('Location: login.php');
        exit;
    }

    // Not allowed yet
    if (intval($user['allow']) !== 1) {
        $_SESSION['error'] = "Your application is in progress. Please wait for admin approval.";
        header('Location: login.php');
        exit;
    }

    // Verify password
    if (!password_verify($password, $user['password'])) {
        $_SESSION['error'] = "Invalid email or password.";
        header('Location: login.php');
        exit;
    }

    // Set session and role
    $_SESSION['user_id'] = $user['id'];
    $_SESSION['fullname'] = $user['fullname'];
    $_SESSION['email'] = $user['email'];
    $_SESSION['filter'] = $user['filter']; // 'user' or 'agent'
    $_SESSION['allow'] = intval($user['allow']);

    // Increment login counter
    $conn->prepare("UPDATE signin SET login_count = login_count + 1 WHERE id = ?")
        ->execute([$user['id']]);

    // Redirect: you can redirect both to index or role dashboard
    header('Location: index.php');
    exit;
}
?>
<!-- (Your existing HTML login form goes here; unchanged) -->


















<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <?php include 'winTab.php' ?>
    <title>Login</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .logo {
    display: flex;
    align-items: center;
}

.logo img {
    margin-top: 5px;
    height: 50px; /* Adjust as needed */
    width: auto;
    max-width: 200px; /* Prevent logo from being too wide */
}

.text-logo {
    font-size: 1.5rem;
    font-weight: bold;
    color: #333; /* Adjust color to match your design */
    text-decoration: none;
}

/* For responsive design */
@media (max-width: 768px) {
    .logo img {
        height: 35px;
    }
    
    .text-logo {
        font-size: 1.3rem;
    }
}

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        :root {
            --primary: #3b82f6;
            --secondary: #1e40af;
            --accent: #60a5fa;
            --dark: #0f172a;
            --darker: #020617;
            --light: #f8fafc;
            --text: #cbd5e1;
            --text-dark: #94a3b8;
            --success: #10b981;
            --card-bg: #1e293b;
            --header-bg: rgba(15, 23, 42, 0.95);
            --footer-bg: #020617;
        }

        [data-theme="light"] {
            --primary: #3b82f6;
            --secondary: #1e40af;
            --accent: #60a5fa;
            --dark: #f1f5f9;
            --darker: #e2e8f0;
            --light: #0f172a;
            --text: #334155;
            --text-dark: #475569;
            --success: #10b981;
            --card-bg: #ffffff;
            --header-bg: rgba(255, 255, 255, 0.95);
            --footer-bg: #e2e8f0;
        }

        body {
            background: linear-gradient(135deg, var(--darker), var(--dark));
            color: var(--text);
            line-height: 1.6;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            transition: background 0.3s ease, color 0.3s ease;
        }

        .container {
            width: 90%;
            max-width: 1200px;
            margin: 0 auto;
        }

        /* Header & Navigation */
        header {
            background: var(--header-bg);
            color: var(--text);
            /* padding: 1rem 0; */
            position: sticky;
            top: 0;
            z-index: 1000;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            backdrop-filter: blur(10px);
            transition: background 0.3s ease;
        }

        

        /* Theme Toggle */
        .theme-toggle {
            background: transparent;
            border: none;
            color: var(--text);
            cursor: pointer;
            font-size: 1.2rem;
            padding: 0.5rem;
            border-radius: 50%;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .theme-toggle:hover {
            background: rgba(255, 255, 255, 0.1);
            transform: rotate(30deg);
        }

        .theme-toggle .fa-sun {
            display: none;
        }

        [data-theme="light"] .theme-toggle .fa-sun {
            display: block;
        }

        [data-theme="light"] .theme-toggle .fa-moon {
            display: none;
        }

        /* Login Section */
        .login-section {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 3rem 0;
        }

        .login-container {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 4rem;
            align-items: center;
            max-width: 1000px;
            width: 100%;
        }

        .login-info {
            padding: 2rem;
        }

        .login-info h1 {
            font-size: 2.5rem;
            color: var(--light);
            margin-bottom: 1.5rem;
            line-height: 1.3;
        }

        .login-info p {
            font-size: 1.1rem;
            margin-bottom: 2rem;
            color: var(--text);
        }

        .features-list {
            list-style: none;
            margin-top: 2rem;
        }

        .features-list li {
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .features-list i {
            color: var(--success);
            font-size: 1.2rem;
        }

        .login-form-container {
            background: var(--card-bg);
            border-radius: 15px;
            padding: 3rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.05);
            position: relative;
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .login-form-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 4px;
            background: var(--primary);
        }

        .form-header {
            text-align: center;
            margin-bottom: 2rem;
        }

        .form-header h2 {
            font-size: 2rem;
            color: var(--light);
            margin-bottom: 0.5rem;
        }

        .form-header p {
            color: var(--text);
        }

        .login-form {
            display: flex;
            flex-direction: column;
            gap: 1.5rem;
        }

        .form-group {
            display: flex;
            flex-direction: column;
            gap: 0.5rem;
        }

        .form-group label {
            color: var(--light);
            font-weight: 500;
        }

        .input-with-icon {
            position: relative;
        }

        .input-with-icon i {
            position: absolute;
            left: 1rem;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-dark);
        }

        .form-control {
            width: 100%;
            padding: 1rem 1rem 1rem 3rem;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            color: var(--text);
            font-size: 1rem;
            transition: all 0.3s ease;
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 2px rgba(59, 130, 246, 0.2);
        }

        .form-options {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1rem;
        }

        .remember-me {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .remember-me input {
            accent-color: var(--primary);
        }

        .forgot-password {
            color: var(--primary);
            text-decoration: none;
            font-size: 0.9rem;
            transition: all 0.3s ease;
        }

        .forgot-password:hover {
            color: var(--accent);
            text-decoration: underline;
        }

        .btn-login-form {
            background: var(--primary);
            color: white;
            border: none;
            padding: 1rem;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            font-size: 1rem;
            margin-top: 0.5rem;
        }

        .btn-login-form:hover {
            background: var(--secondary);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(59, 130, 246, 0.4);
        }

        .divider {
            display: flex;
            align-items: center;
            margin: 1.5rem 0;
            color: var(--text-dark);
        }

        .divider::before,
        .divider::after {
            content: '';
            flex: 1;
            height: 1px;
            background: rgba(255, 255, 255, 0.1);
        }

        .divider span {
            padding: 0 1rem;
            font-size: 0.9rem;
        }

        .social-login {
            display: flex;
            gap: 1rem;
            margin-bottom: 1.5rem;
        }

        .btn-social {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            padding: 0.8rem;
            border-radius: 8px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
            border: 1px solid rgba(255, 255, 255, 0.1);
            background: rgba(255, 255, 255, 0.05);
            color: var(--text);
        }

        .btn-social:hover {
            background: rgba(255, 255, 255, 0.1);
            transform: translateY(-2px);
        }

        .btn-google {
            color: #ea4335;
        }

        .btn-linkedin {
            color: #0a66c2;
        }

        .signup-link {
            text-align: center;
            margin-top: 1.5rem;
            color: var(--text);
        }

        .signup-link a {
            color: var(--primary);
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .signup-link a:hover {
            color: var(--accent);
            text-decoration: underline;
        }

        /* Footer */
        footer {
            background: var(--footer-bg);
            color: var(--text);
            padding: 2rem 0 1rem;
            border-top: 1px solid rgba(255, 255, 255, 0.05);
            margin-top: auto;
            transition: background 0.3s ease;
        }

        .footer-content {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 2rem;
            margin-bottom: 2rem;
        }

        .footer-column h3 {
            font-size: 1.2rem;
            margin-bottom: 1rem;
            position: relative;
            padding-bottom: 10px;
            color: var(--light);
        }

        .footer-column h3::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 40px;
            height: 3px;
            background: var(--primary);
        }

        .footer-links {
            list-style: none;
        }

        .footer-links li {
            margin-bottom: 0.8rem;
        }

        .footer-links a {
            color: var(--text-dark);
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .footer-links a:hover {
            color: var(--light);
            padding-left: 5px;
        }

        .social-links {
            display: flex;
            gap: 1rem;
            margin-top: 1rem;
        }

        .social-links a {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.05);
            border-radius: 50%;
            color: var(--text);
            transition: all 0.3s ease;
        }

        .social-links a:hover {
            background: var(--primary);
            color: white;
            transform: translateY(-3px);
        }

        .footer-bottom {
            text-align: center;
            padding-top: 1.5rem;
            border-top: 1px solid rgba(255, 255, 255, 0.05);
            color: var(--text-dark);
            font-size: 0.9rem;
        }

        /* Animations */
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        @keyframes slideUp {
            from { 
                opacity: 0;
                transform: translateY(30px);
            }
            to { 
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Responsive Design */
      



        .alert {
    width: 90%;
    max-width: 500px;
    margin: 1rem auto;
    padding: 1rem 1.5rem;
    border-radius: 8px;
    font-weight: 500;
    text-align: center;
}

.alert-error {
    background: #fee2e2;
    color: #b91c1c;
    border: 1px solid #fca5a5;
}

.alert-success {
    background: #d1fae5;
    color: #065f46;
    border: 1px solid #6ee7b7;
}

    </style>
</head>
<body>
    <?php
if (!empty($_SESSION['error'])) {
    echo '<div class="alert alert-error">' . $_SESSION['error'] . '</div>';
    unset($_SESSION['error']);
}

if (!empty($_SESSION['success'])) {
    echo '<div class="alert alert-success">' . $_SESSION['success'] . '</div>';
    unset($_SESSION['success']);
}
?>

    <!-- Header -->
<?php  include 'header.php'; ?>
    <!-- Login Section -->
    <section class="login-section">
        <div class="container">
            <div class="login-container">
                <div class="login-info">
                    <h1>Welcome Back to Your Career Journey</h1>
                    <p>Sign in to access your personalized dashboard, saved jobs, and application history.</p>
                    
                    <ul class="features-list">
                        <li>
                            <i class="fas fa-check-circle"></i>
                            <span>Access thousands of job listings</span>
                        </li>
                        <li>
                            <i class="fas fa-check-circle"></i>
                            <span>Track your application status</span>
                        </li>
                        <li>
                            <i class="fas fa-check-circle"></i>
                            <span>Get personalized job recommendations</span>
                        </li>
                        <li>
                            <i class="fas fa-check-circle"></i>
                            <span>Connect with top employers</span>
                        </li>
                    </ul>
                </div>
                
                <div class="login-form-container">
                    <div class="form-header">
                        <h2>Sign In</h2>
                        <p>Enter your credentials to access your account</p>
                    </div>
                    
                    
                    <form class="login-form" id="loginForm" method="POST" action="login.php">
                        <div class="form-group">
                            <label for="email">Email Address</label>
                            <div class="input-with-icon">
                                <i class="fas fa-envelope"></i>
                                <input type="email" id="email" class="form-control" name="email" placeholder="Enter your email" required>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="password">Password</label>
                            <div class="input-with-icon">
                                <i class="fas fa-lock"></i>
                                <input type="password" id="password" class="form-control" name="password" placeholder="Enter your password" required>
                            </div>
                        </div>
                        
                        <div class="form-options">
                            <div class="remember-me">
                                <input type="checkbox" id="remember">
                                <label for="remember">Remember me</label>
                            </div>
                            <a href="#" class="forgot-password">Forgot password?</a>
                        </div>
                        
                        <button type="submit" class="btn-login-form">Log In</button>
                    </form>
                    
                    <div class="divider">
                        <span>Or continue with</span>
                    </div>
                    
                    <div class="social-login">
                        <button class="btn-social btn-google">
                            <i class="fab fa-google"></i>
                            <span>Google</span>
                        </button>
                        <button class="btn-social btn-linkedin">
                            <i class="fab fa-linkedin"></i>
                            <span>LinkedIn</span>
                        </button>
                    </div>
                    
                    <div class="signup-link">
                        <p>Don't have an account? <a href="signin.php">Sign up now</a></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <?php  include 'footer.php'; ?>

    <script>
        // Theme Toggle Functionality
        const themeToggle = document.getElementById('themeToggle');
        const prefersDarkScheme = window.matchMedia('(prefers-color-scheme: dark)');
        
        // Check for saved theme preference or use device preference
        const currentTheme = localStorage.getItem('theme') || 
                            (prefersDarkScheme.matches ? 'dark' : 'light');
        
        // Set initial theme
        document.documentElement.setAttribute('data-theme', currentTheme);
        
        // Toggle theme on button click
        themeToggle.addEventListener('click', function() {
            const currentTheme = document.documentElement.getAttribute('data-theme');
            const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
            
            document.documentElement.setAttribute('data-theme', newTheme);
            localStorage.setItem('theme', newTheme);
        });

        // Simple animation on scroll
        document.addEventListener('DOMContentLoaded', function() {
            const animatedElements = document.querySelectorAll('.login-info, .login-form-container');
            
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.style.opacity = '1';
                        entry.target.style.transform = 'translateY(0)';
                    }
                });
            }, { threshold: 0.1 });
            
            animatedElements.forEach(el => {
                el.style.opacity = '0';
                el.style.transform = 'translateY(20px)';
                el.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
                observer.observe(el);
            });

            // Login Form Submission
            // const loginForm = document.getElementById('loginForm');
            // loginForm.addEventListener('submit', function(e) {
            //     e.preventDefault();
                
            //     // Get form values
            //     const email = document.getElementById('email').value;
            //     const password = document.getElementById('password').value;
            //     const remember = document.getElementById('remember').checked;
                
            //     // Simple validation
            //     if (!email || !password) {
            //         alert('Please fill in all required fields.');
            //         return;
            //     }
                
            //     // Show success message (in a real app, this would be an API call)
            //     alert(`Welcome back! You've successfully signed in. ${remember ? 'We\'ll remember your login.' : ''}`);
                
            //     // In a real application, you would redirect to the dashboard
            //     // window.location.href = 'dashboard.php';
            // });

            // Social Login Buttons
            const socialButtons = document.querySelectorAll('.btn-social');
            socialButtons.forEach(button => {
                button.addEventListener('click', () => {
                    const platform = button.querySelector('span').textContent;
                    alert(`You've chosen to sign in with ${platform}. This would redirect you to their authentication service.`);
                });
            });

            // Forgot Password Link
            const forgotPassword = document.querySelector('.forgot-password');
            forgotPassword.addEventListener('click', (e) => {
                e.preventDefault();
                alert('You will be redirected to the password reset page.');
            });

            // Apply Now button functionality
            const applyButtons = document.querySelectorAll('.btn-login');
            // applyButtons.forEach(button => {
            //     if (button.textContent === 'Apply Now') {
            //         button.addEventListener('click', () => {
            //             alert('You will be redirected to the job application page.');
            //         });
            //     }
            // });
        });
    </script>
</body>
</html>