
<style>
    .navbar {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .logo {
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 1.8rem;
            font-weight: 700;
            animation: fadeIn 1s ease;
        }

        .logo i {
            color: #fbbf24;
        }

        .nav-links {
            display: flex;
            list-style: none;
            gap: 2rem;
        }

        .nav-links a {
            color: var(--text);
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s ease;
            position: relative;
        }

        .nav-links a:hover {
            color: #fbbf24;
        }

        .nav-links a::after {
            content: '';
            position: absolute;
            bottom: -5px;
            left: 0;
            width: 0;
            height: 2px;
            background-color: #fbbf24;
            transition: width 0.3s ease;
        }

        .nav-links a:hover::after {
            width: 100%;
        }

        .auth-buttons {
            display: flex;
            gap: 1rem;
            align-items: center;
        }

        .btn {
            padding: 0.6rem 1.5rem;
            border-radius: 50px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            border: none;
        }

        .btn-login {
            background: transparent;
            color: white;
            border: 2px solid var(--primary);
        }

        [data-theme="light"] .btn-login {
            color: var(--text);
        }

        .btn-login:hover {
            background: var(--primary);
            color: white;
        }

        .btn-signup {
            background: #fbbf24;
            color: var(--dark);
        }

        .btn-signup:hover {
            background: #f59e0b;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(245, 158, 11, 0.4);
        }
          @media (max-width: 768px) {
            .navbar {
                flex-direction: column;
                gap: 1rem;
            }

            .nav-links {
                gap: 1rem;
                flex-wrap: wrap;
                justify-content: center;
            }

            .hero h1 {
                font-size: 2.2rem;
            }

            .search-box {
                flex-direction: column;
                border-radius: 10px;
            }

            .search-box input,
            .search-box button {
                width: 100%;
                border-radius: 1;
            }

            .job-cards {
                grid-template-columns: 1fr;
            }
        }

        .logo {
            display: flex;
            align-items: center;
        }

        .logo img {
            margin-top: 5px;
            height: 80px;
            /* Adjust as needed */
            width: auto;
            max-width: 200px;
            filter: drop-shadow(5px 5px 10px rgba(31, 30, 30, 0.5));
            /* Prevent logo from being too wide */
        }

        .text-logo {
            font-size: 1.5rem;
            font-weight: bold;
            color: #333;
            /* Adjust color to match your design */
            text-decoration: none;
        }
        

        /* For responsive design */
        @media (max-width: 768px) {
            .logo img {
                height: 50px;
            }

            .text-logo {
                font-size: 1.3rem;
            }
        
        }
</style>



<header>
    <div class="container">
        <nav class="navbar">
            <div class="logo">
                <!-- Replace with your actual logo image -->
                <!-- <b style="font-size: 70%;">The Work & Workers Job</b> -->
                <!-- Alternative text logo if image is not available -->
                <a href="index.php" class="text-logo">
                    <img class="logosize" src="./img/logo.png"></img>
                </a>
            </div>
            <ul class="nav-links">
                <li><a href="index.php" class="active">Home</a></li>
                <li><a href="about.php">About Us</a></li>
                <!-- <li><a href="servcies.php">Services</a></li> -->
                <li><a href="joblist.php">Job List</a></li>
                <li><a href="contact.php">Contact Us</a></li>
            </ul>
            <div class="auth-buttons">
                <button class="theme-toggle" id="themeToggle">
                    <i class="fas fa-moon"></i>
                </button>
                 <a href="post.php"><button class="btn btn-login">Post a Job</button></a>
                <a href="apply.php"><button class="btn btn-login">Apply Now</button></a>
                <a href="login.php"><button class="btn btn-login">Login</button></a>
                <a href="signup.php"><button class="btn btn-signup">Sign Up</button></a>
            </div>
        </nav>
    </div>
</header>