<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <?php include 'winTab.php' ?>
    <title>Contact Us</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .logo {
    display: flex;
    align-items: center;
}

.logo img {
    margin-top: 5px;
    height: 50px; /* Adjust as needed */
    width: auto;
    max-width: 200px; /* Prevent logo from being too wide */
}

.text-logo {
    font-size: 1.5rem;
    font-weight: bold;
    color: #333; /* Adjust color to match your design */
    text-decoration: none;
}

/* For responsive design */
@media (max-width: 768px) {
    .logo img {
        height: 35px;
    }
    
    .text-logo {
        font-size: 1.3rem;
    }
}

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        :root {
            --primary: #3b82f6;
            --secondary: #1e40af;
            --accent: #60a5fa;
            --dark: #0f172a;
            --darker: #020617;
            --light: #f8fafc;
            --text: #cbd5e1;
            --text-dark: #94a3b8;
            --success: #10b981;
            --card-bg: #1e293b;
        }

        /* Light mode variables */
        [data-theme="light"] {
            --primary: #3b82f6;
            --secondary: #1e40af;
            --accent: #60a5fa;
            --dark: #f1f5f9;
            --darker: #e2e8f0;
            --light: #0f172a;
            --text: #334155;
            --text-dark: #475569;
            --success: #10b981;
            --card-bg: #ffffff;
        }

        body {
            background: linear-gradient(135deg, var(--darker), var(--dark));
            color: var(--text);
            line-height: 1.6;
            overflow-x: hidden;
            transition: all 0.3s ease;
        }

        .container {
            width: 90%;
            max-width: 1200px;
            margin: 0 auto;
        }

        /* Header & Navigation */
        header {
            background: rgba(15, 23, 42, 0.95);
            color: white;
            padding: 1rem 0;
            position: sticky;
            top: 0;
            z-index: 1000;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
            backdrop-filter: blur(10px);
            transition: all 0.3s ease;
        }

        [data-theme="light"] header {
            background: rgba(255, 255, 255, 0.95);
            color: var(--text);
        }

        

        /* Theme Toggle Button */
        .theme-toggle {
            background: transparent;
            border: none;
            color: var(--text);
            cursor: pointer;
            font-size: 1.2rem;
            padding: 0.5rem;
            border-radius: 50%;
            transition: all 0.3s ease;
        }

        .theme-toggle:hover {
            background: rgba(255, 255, 255, 0.1);
        }

        [data-theme="light"] .theme-toggle:hover {
            background: rgba(0, 0, 0, 0.05);
        }

        /* Hero Section */
        .hero {
            background: linear-gradient(rgba(15, 23, 42, 0.85), rgba(2, 6, 23, 0.9)), url('https://images.unsplash.com/photo-1565688534245-05d6d69f9d15?ixlib=rb-4.0.3&auto=format&fit=crop&w=1950&q=80');
            background-size: cover;
            background-position: center;
            color: white;
            padding: 6rem 0;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        [data-theme="light"] .hero {
            background: linear-gradient(rgba(255, 255, 255, 0.85), rgba(226, 232, 240, 0.9)), url('https://images.unsplash.com/photo-1565688534245-05d6d69f9d15?ixlib=rb-4.0.3&auto=format&fit=crop&w=1950&q=80');
            color: var(--text);
        }

        .hero-content {
            max-width: 800px;
            margin: 0 auto;
            animation: slideUp 1s ease;
        }

        .hero h1 {
            font-size: 3.5rem;
            margin-bottom: 1.5rem;
            line-height: 1.2;
            text-shadow: 0 2px 10px rgba(0, 0, 0, 0.3);
        }

        .hero p {
            font-size: 1.2rem;
            margin-bottom: 2rem;
            opacity: 0.9;
        }

        /* Contact Section */
        .contact {
            padding: 5rem 0;
            background: var(--darker);
            transition: all 0.3s ease;
        }

        .section-title {
            text-align: center;
            margin-bottom: 3rem;
        }

        .section-title h2 {
            font-size: 2.5rem;
            color: white;
            margin-bottom: 1rem;
            position: relative;
            display: inline-block;
        }

        [data-theme="light"] .section-title h2 {
            color: var(--text);
        }

        .section-title h2::after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 4px;
            background: var(--primary);
            border-radius: 2px;
        }

        .section-title p {
            max-width: 700px;
            margin: 0 auto;
            color: var(--text);
        }

        .contact-container {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 4rem;
        }

        .contact-info {
            display: flex;
            flex-direction: column;
            gap: 2rem;
        }

        .contact-card {
            background: var(--card-bg);
            border-radius: 10px;
            padding: 2rem;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.05);
            transition: all 0.3s ease;
        }

        [data-theme="light"] .contact-card {
            border: 1px solid rgba(0, 0, 0, 0.05);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
        }

        .contact-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.3);
        }

        [data-theme="light"] .contact-card:hover {
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
        }

        .contact-icon {
            width: 60px;
            height: 60px;
            background: rgba(59, 130, 246, 0.1);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 1.5rem;
            font-size: 1.5rem;
            color: var(--primary);
        }

        .contact-card h3 {
            margin-bottom: 1rem;
            color: white;
        }

        [data-theme="light"] .contact-card h3 {
            color: var(--text);
        }

        .contact-card p {
            color: var(--text);
            margin-bottom: 0.5rem;
        }

        .contact-form {
            background: var(--card-bg);
            border-radius: 10px;
            padding: 2.5rem;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.05);
        }

        [data-theme="light"] .contact-form {
            border: 1px solid rgba(0, 0, 0, 0.05);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            color: white;
            font-weight: 500;
        }

        [data-theme="light"] .form-group label {
            color: var(--text);
        }

        .form-control {
            width: 100%;
            padding: 1rem;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 5px;
            color: white;
            font-size: 1rem;
            transition: all 0.3s ease;
        }

        [data-theme="light"] .form-control {
            background: rgba(0, 0, 0, 0.05);
            border: 1px solid rgba(0, 0, 0, 0.1);
            color: var(--text);
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 2px rgba(59, 130, 246, 0.2);
        }

        textarea.form-control {
            min-height: 150px;
            resize: vertical;
        }

        .btn-submit {
            background: var(--primary);
            color: white;
            border: none;
            padding: 1rem 2rem;
            border-radius: 50px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            width: 100%;
            font-size: 1rem;
        }

        .btn-submit:hover {
            background: var(--secondary);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(59, 130, 246, 0.4);
        }

        /* FAQ Section */
        .faq {
            padding: 5rem 0;
            background: var(--dark);
            transition: all 0.3s ease;
        }

        .faq-container {
            max-width: 800px;
            margin: 0 auto;
        }

        .faq-item {
            background: var(--card-bg);
            border-radius: 10px;
            margin-bottom: 1rem;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.05);
        }

        [data-theme="light"] .faq-item {
            border: 1px solid rgba(0, 0, 0, 0.05);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
        }

        .faq-question {
            padding: 1.5rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .faq-question:hover {
            background: rgba(255, 255, 255, 0.03);
        }

        [data-theme="light"] .faq-question:hover {
            background: rgba(0, 0, 0, 0.03);
        }

        .faq-question h3 {
            color: white;
            font-size: 1.1rem;
        }

        [data-theme="light"] .faq-question h3 {
            color: var(--text);
        }

        .faq-icon {
            color: var(--primary);
            transition: transform 0.3s ease;
        }

        .faq-answer {
            padding: 0 1.5rem;
            max-height: 0;
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .faq-item.active .faq-answer {
            padding: 0 1.5rem 1.5rem;
            max-height: 500px;
        }

        .faq-item.active .faq-icon {
            transform: rotate(180deg);
        }

        /* Map Section */
        .map {
            padding: 5rem 0;
            background: var(--darker);
            transition: all 0.3s ease;
        }

        .map-container {
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
            height: 400px;
            background: var(--card-bg);
            display: flex;
            align-items: center;
            justify-content: center;
            flex-direction: column;
            gap: 1rem;
        }

        [data-theme="light"] .map-container {
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }

        .map-placeholder {
            text-align: center;
            color: var(--text);
        }

        .map-placeholder i {
            font-size: 3rem;
            color: var(--primary);
            margin-bottom: 1rem;
        }

        /* CTA Section */
        .cta {
            background: linear-gradient(135deg, var(--primary), var(#1a1b1c));
            color: white;
            padding: 5rem 0;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .cta::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: url('https://images.unsplash.com/photo-1552664730-d307ca884978?ixlib=rb-4.0.3&auto=format&fit=crop&w=1000&q=80');
            background-size: cover;
            background-position: center;
            opacity: 0.1;
        }

        .cta h2 {
            font-size: 2.5rem;
            margin-bottom: 1.5rem;
            position: relative;
        }

        .cta p {
            max-width: 700px;
            margin: 0 auto 2rem;
            font-size: 1.1rem;
            position: relative;
        }

        .btn-cta {
            background: #fbbf24;
            color: var(--dark);
            padding: 1rem 2.5rem;
            font-size: 1.1rem;
            border-radius: 50px;
            display: inline-block;
            transition: all 0.3s ease;
            position: relative;
            font-weight: 600;
            text-decoration: none;
        }

        .btn-cta:hover {
            background: #f59e0b;
            transform: translateY(-3px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
        }

        /* Footer */
        footer {
            background: var(--darker);
            color: white;
            padding: 4rem 0 2rem;
            border-top: 1px solid rgba(255, 255, 255, 0.05);
            transition: all 0.3s ease;
        }

        [data-theme="light"] footer {
            color: var(--text);
            border-top: 1px solid rgba(0, 0, 0, 0.05);
        }

        .footer-content {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 3rem;
            margin-bottom: 3rem;
        }

        .footer-column h3 {
            font-size: 1.3rem;
            margin-bottom: 1.5rem;
            position: relative;
            padding-bottom: 10px;
            color: white;
        }

        [data-theme="light"] .footer-column h3 {
            color: var(--text);
        }

        .footer-column h3::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 40px;
            height: 3px;
            background: var(--primary);
        }

        .footer-links {
            list-style: none;
        }

        .footer-links li {
            margin-bottom: 0.8rem;
        }

        .footer-links a {
            color: var(--text-dark);
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .footer-links a:hover {
            color: white;
            padding-left: 5px;
        }

        [data-theme="light"] .footer-links a:hover {
            color: var(--text);
        }

        .social-links {
            display: flex;
            gap: 1rem;
            margin-top: 1.5rem;
        }

        .social-links a {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.05);
            border-radius: 50%;
            color: var(--text);
            transition: all 0.3s ease;
        }

        [data-theme="light"] .social-links a {
            background: rgba(0, 0, 0, 0.05);
        }

        .social-links a:hover {
            background: var(--primary);
            color: white;
            transform: translateY(-3px);
        }

        .footer-bottom {
            text-align: center;
            padding-top: 2rem;
            border-top: 1px solid rgba(255, 255, 255, 0.05);
            color: var(--text-dark);
            font-size: 0.9rem;
        }

        [data-theme="light"] .footer-bottom {
            border-top: 1px solid rgba(0, 0, 0, 0.05);
        }

        /* Animations */
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        @keyframes slideUp {
            from { 
                opacity: 0;
                transform: translateY(30px);
            }
            to { 
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Responsive Design */
        @media (max-width: 992px) {
            .contact-container {
                grid-template-columns: 1fr;
                gap: 3rem;
            }
            
            .hero h1 {
                font-size: 2.8rem;
            }
        }

            
    </style>
</head>
<body>
      <!-- Header -->
<?php  include 'header.php'; ?>
    <!-- Hero Section -->
    <section class="hero">
        <div class="container">
            <div class="hero-content">
                <h1>Get In Touch With Us</h1>
                <p>Have questions or need assistance? Our team is here to help you with your career journey.</p>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    <section class="contact">
        <div class="container">
            <div class="section-title">
                <h2>Contact Us</h2>
                <p>Reach out to us through any of the following methods or send us a message directly.</p>
            </div>
            <div class="contact-container">
                <div class="contact-info">
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-map-marker-alt"></i>
                        </div>
                        <h3>Our Location</h3>
                        <p>Lahore</p>
                        <p> Pakista </p>
                        <p>world</p>
                    </div>
                    
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-phone"></i>
                        </div>
                        <h3>Phone Number</h3>
                        <p>0000000000</p>
                        <p>+0000000000</p>
                        <p>+0000000000</p>
                        <p>+0000000000</p>
                        <p>+0000000000</p>
                        <p>+0000000000</p>
                        <p>Mon-Sat: 9am-6pm EST</p>
                    </div>
                    
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-envelope"></i>
                        </div>
                        <h3>Email Address</h3>
                        <p>Pakistan.com</p>
                        <p>support@careerconnect.com</p>
                        <p>jobs@careerconnect.com</p>
                    </div>
                </div>
                
                <div class="contact-form">
                    <h3 style="color: white; margin-bottom: 1.5rem;">Send Us a Message</h3>
                    <form id="contactForm">
                        <div class="form-group">
                            <label for="name">Full Name</label>
                            <input type="text" id="name" class="form-control" placeholder="Enter your full name" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="email">Email Address</label>
                            <input type="email" id="email" class="form-control" placeholder="Enter your email address" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="subject">Subject</label>
                            <input type="text" id="subject" class="form-control" placeholder="Enter the subject" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="message">Message</label>
                            <textarea id="message" class="form-control" placeholder="Enter your message" required></textarea>
                        </div>
                        
                        <button type="submit" class="btn-submit">Send Message</button>
                    </form>
                </div>
            </div>
        </div>
    </section>

    <!-- FAQ Section -->
    <section class="faq">
        <div class="container">
            <div class="section-title">
                <h2>Frequently Asked Questions</h2>
                <p>Find answers to common questions about our services and platform.</p>
            </div>
            <div class="faq-container">
                <div class="faq-item">
                    <div class="faq-question">
                        <h3>How do I create an account on Work And Workers?</h3>
                        <i class="fas fa-chevron-down faq-icon"></i>
                    </div>
                    <div class="faq-answer">
                        <p>Creating an account is simple. Click on the "Sign Up" button in the top navigation, fill in your details, verify your email address, and you're ready to start exploring job opportunities.</p>
                    </div>
                </div>
                
                <div class="faq-item">
                    <div class="faq-question">
                        <h3>Is Work and Workers free for job seekers?</h3>
                        <i class="fas fa-chevron-down faq-icon"></i>
                    </div>
                    <div class="faq-answer">
                        <p>Yes, our basic services are completely free for job seekers. You can create a profile, search for jobs, and apply to positions without any cost. We also offer premium services with additional features for those who need them.</p>
                    </div>
                </div>
                
                <div class="faq-item">
                    <div class="faq-question">
                        <h3>How can employers post jobs on Work And Workers?</h3>
                        <i class="fas fa-chevron-down faq-icon"></i>
                    </div>
                    <div class="faq-answer">
                        <p>Employers can create a company account, verify their business, and then post job listings through our employer dashboard. We offer various posting packages to suit different hiring needs.</p>
                    </div>
                </div>
                
                <div class="faq-item">
                    <div class="faq-question">
                        <h3>What types of jobs are available on Work And Workers?</h3>
                        <i class="fas fa-chevron-down faq-icon"></i>
                    </div>
                    <div class="faq-answer">
                        <p>We feature jobs across all industries and experience levels, from entry-level positions to executive roles. Our categories include technology, healthcare, finance, education, manufacturing, and many more.</p>
                    </div>
                </div>
                
                <div class="faq-item">
                    <div class="faq-question">
                        <h3>How does Work and Workers protect my personal information?</h3>
                        <i class="fas fa-chevron-down faq-icon"></i>
                    </div>
                    <div class="faq-answer">
                        <p>We take data privacy seriously. Your personal information is encrypted and stored securely. We never share your data with third parties without your explicit consent, and you have full control over what information is visible to employers.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Map Section -->
    <section class="map">
        <div class="container">
            <div class="section-title">
                <h2>Visit Our Office</h2>
                <p>Come see us at our headquarters in Lahore City.</p>
            </div>
            <div class="map-container">
                <div class="map-placeholder">
                    <i class="fas fa-map-marked-alt"></i>
                    <h3>Work and Workers Headquarters</h3>
                    <p>Office #3, 4 Floor, Gohar Centre Muslim Town,</p>
                    <p>Wahdat Road, Lahore</p>
                    <p>Open Mon-Sat: 9am-6pm EST</p>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta">
        <div class="container">
            <h2>Ready to Take the Next Step in Your Career?</h2>
            <p>Join thousands of professionals who have found their dream jobs through Work And Workers. Create your profile today and let employers find you!</p>
            <a href="#" class="btn btn-cta">Create Your Profile Now</a>
        </div>
    </section>

    <!-- Footer -->
    <?php  include 'footer.php'; ?>


    <script>
        // Simple animation on scroll
        document.addEventListener('DOMContentLoaded', function() {
            const animatedElements = document.querySelectorAll('.contact-card, .contact-form, .faq-item, .map-container');
            
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.style.opacity = '1';
                        entry.target.style.transform = 'translateY(0)';
                    }
                });
            }, { threshold: 0.1 });
            
            animatedElements.forEach(el => {
                el.style.opacity = '0';
                el.style.transform = 'translateY(20px)';
                el.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
                observer.observe(el);
            });

            // FAQ Accordion Functionality
            const faqItems = document.querySelectorAll('.faq-item');
            faqItems.forEach(item => {
                const question = item.querySelector('.faq-question');
                question.addEventListener('click', () => {
                    // Close all other items
                    faqItems.forEach(otherItem => {
                        if (otherItem !== item) {
                            otherItem.classList.remove('active');
                        }
                    });
                    
                    // Toggle current item
                    item.classList.toggle('active');
                });
            });

            // Contact Form Submission
            const contactForm = document.getElementById('contactForm');
            contactForm.addEventListener('submit', function(e) {
                e.preventDefault();
                
                // Get form values
                const name = document.getElementById('name').value;
                const email = document.getElementById('email').value;
                const subject = document.getElementById('subject').value;
                
                // Show success message
                alert(`Thank you ${name}! Your message has been sent successfully. We'll get back to you at ${email} within 24 hours.`);
                
                // Reset form
                contactForm.reset();
            });

            // Apply Now button functionality
            const applyButtons = document.querySelectorAll('.btn-login');
            applyButtons.forEach(button => {
                if (button.textContent === 'Apply Now') {
                    button.addEventListener('click', () => {
                        alert('You will be redirected to the job application page.');
                    });
                }
            });

            // Theme toggle functionality
            const themeToggle = document.getElementById('themeToggle');
            const themeIcon = themeToggle.querySelector('i');
            
            // Check for saved theme preference or default to dark
            const currentTheme = localStorage.getItem('theme') || 'dark';
            document.documentElement.setAttribute('data-theme', currentTheme);
            
            // Update icon based on current theme
            if (currentTheme === 'light') {
                themeIcon.classList.remove('fa-moon');
                themeIcon.classList.add('fa-sun');
            } else {
                themeIcon.classList.remove('fa-sun');
                themeIcon.classList.add('fa-moon');
            }
            
            themeToggle.addEventListener('click', () => {
                const currentTheme = document.documentElement.getAttribute('data-theme');
                const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
                
                // Update theme
                document.documentElement.setAttribute('data-theme', newTheme);
                localStorage.setItem('theme', newTheme);
                
                // Update icon
                if (newTheme === 'light') {
                    themeIcon.classList.remove('fa-moon');
                    themeIcon.classList.add('fa-sun');
                } else {
                    themeIcon.classList.remove('fa-sun');
                    themeIcon.classList.add('fa-moon');
                }
            });
        });
    </script>
</body>
</html>