<?php
require_once 'connection.php';  // Include once to avoid duplicate load

$conn = Database::connect(); // ✅ Get the PDO connection


// Handle Form Submission
if ($_SERVER["REQUEST_METHOD"] === "POST") {

    try {
        $sql = "INSERT INTO apply (
            position_applied, desired_salary, date_available, current_position, nic_number, desired_city,
            applicant_name, father_or_husband_name, current_address, permanent_address,
            city_district, total_experience, home_phone, cell_phone, email, whatsapp_no,
            degree, year_passed, division, board,
            company_name, position_of_job, main_duty1, duration_of_duty
        ) VALUES (
            :position_applied, :desired_salary, :date_available, :current_position, :nic_number, :desired_city,
            :applicant_name, :father_or_husband_name, :current_address, :permanent_address,
            :city_district, :total_experience, :home_phone, :cell_phone, :email, :whatsapp_no,
            :degree, :year_passed, :division, :board,
            :company_name, :position_of_job, :main_duty1, :duration_of_duty
        )";

        $stmt = $conn->prepare($sql);

        $stmt->execute([
            ':position_applied' => $_POST['position_applied'] ?? null,
            ':desired_salary' => $_POST['desired_salary'] ?? null,
            ':date_available' => $_POST['date_available'] ?? null,
            ':current_position' => $_POST['current_position'] ?? null,
            ':nic_number' => $_POST['nic_number'] ?? null,
            ':desired_city' => $_POST['desired_city'] ?? null,
            ':applicant_name' => $_POST['applicant_name'] ?? null,
            ':father_or_husband_name' => $_POST['father_or_husband_name'] ?? null,
            ':current_address' => $_POST['current_address'] ?? null,
            ':permanent_address' => $_POST['permanent_address'] ?? null,
            ':city_district' => $_POST['city_district'] ?? null,
            ':total_experience' => $_POST['total_experience'] ?? null,
            ':home_phone' => $_POST['home_phone'] ?? null,
            ':cell_phone' => $_POST['cell_phone'] ?? null,
            ':email' => $_POST['email'] ?? null,
            ':whatsapp_no' => $_POST['whatsapp_no'] ?? null,
            ':degree' => $_POST['degree'] ?? null,
            ':year_passed' => $_POST['year_passed'] ?? null,
            ':division' => $_POST['division'] ?? null,
            ':board' => $_POST['board'] ?? null,
            ':company_name' => $_POST['company_name'] ?? null,
            ':position_of_job' => $_POST['position_of_job'] ?? null,
            ':main_duty1' => $_POST['main_duty1'] ?? null,
            ':duration_of_duty' => $_POST['duration_of_duty'] ?? null
        ]);

        echo "<script>alert('✅ Application submitted successfully!'); window.location='apply.php';</script>";
    } catch (PDOException $e) {
        echo "<pre>❌ SQL Error: " . $e->getMessage() . "</pre>";
    }
}
?>




    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
          <?php include 'winTab.php' ?>
        <title>Job Application</title>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
        <style>

            
            .logo {
        display: flex;
        align-items: center;
    }

    .logo img {
        margin-top: 5px;
        height: 50px; /* Adjust as needed */
        width: auto;
        max-width: 200px; /* Prevent logo from being too wide */
    }

    .text-logo {
        font-size: 1.5rem;
        font-weight: bold;
        color: #333; /* Adjust color to match your design */
        text-decoration: none;
    }

    /* For responsive design */
    @media (max-width: 768px) {
        .logo img {
            height: 35px;
        }
        
        .text-logo {
            font-size: 1.3rem;
        }
    }

            * {
                margin: 0;
                padding: 0;
                box-sizing: border-box;
                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            }

            :root {
                --primary: #3b82f6;
                --secondary: #1e40af;
                --accent: #60a5fa;
                --dark: #0f172a;
                --darker: #020617;
                --light: #f8fafc;
                --text: #cbd5e1;
                --text-dark: #94a3b8;
                --success: #10b981;
                --card-bg: #1e293b;
                --header-bg: rgba(15, 23, 42, 0.95);
                --footer-bg: #020617;
            }

            [data-theme="light"] {
                --primary: #3b82f6;
                --secondary: #1e40af;
                --accent: #60a5fa;
                --dark: #f1f5f9;
                --darker: #e2e8f0;
                --light: #0f172a;
                --text: #334155;
                --text-dark: #475569;
                --success: #10b981;
                --card-bg: #ffffff;
                --header-bg: rgba(255, 255, 255, 0.95);
                --footer-bg: #e2e8f0;
            }

            body {
                background: linear-gradient(135deg, var(--darker), var(--dark));
                color: var(--text);
                line-height: 1.6;
                min-height: 100vh;
                display: flex;
                flex-direction: column;
                transition: background 0.3s ease, color 0.3s ease;
            }

            .container {
                width: 90%;
                max-width: 1200px;
                margin: 0 auto;
            }

            /* Header & Navigation */
            header {
                background: var(--header-bg);
                color: var(--text);
                padding: 1rem 0;
                position: sticky;
                top: 0;
                z-index: 1000;
                box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
                backdrop-filter: blur(10px);
                transition: background 0.3s ease;
            }

            

            /* Theme Toggle */
            .theme-toggle {
                background: transparent;
                border: none;
                color: var(--text);
                cursor: pointer;
                font-size: 1.2rem;
                padding: 0.5rem;
                border-radius: 50%;
                transition: all 0.3s ease;
                display: flex;
                align-items: center;
                justify-content: center;
            }

            .theme-toggle:hover {
                background: rgba(255, 255, 255, 0.1);
                transform: rotate(30deg);
            }

            .theme-toggle .fa-sun {
                display: none;
            }

            [data-theme="light"] .theme-toggle .fa-sun {
                display: block;
            }

            [data-theme="light"] .theme-toggle .fa-moon {
                display: none;
            }

            /* Application Form Section */
            .application-section {
                flex: 1;
                padding: 3rem 0;
            }

            .application-container {
                max-width: 900px;
                margin: 0 auto;
            }

            .application-header {
                text-align: center;
                margin-bottom: 2rem;
            }

            .application-header h1 {
                font-size: 2.5rem;
                color: var(--light);
                margin-bottom: 0.5rem;
            }

            .application-header p {
                color: var(--text);
                font-size: 1.1rem;
            }

            .application-form-container {
                background: var(--card-bg);
                border-radius: 15px;
                padding: 3rem;
                box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
                border: 1px solid rgba(255, 255, 255, 0.05);
                position: relative;
                overflow: hidden;
                transition: all 0.3s ease;
            }

            .application-form-container::before {
                content: '';
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 4px;
                background: var(--primary);
            }

            .form-note {
                background: rgba(255, 255, 255, 0.05);
                padding: 1rem;
                border-radius: 8px;
                margin-bottom: 2rem;
                border-left: 4px solid #fbbf24;
            }

            .form-note p {
                color: var(--text);
                font-size: 0.95rem;
            }

            .form-section {
                margin-bottom: 2.5rem;
                padding-bottom: 1.5rem;
                border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            }

            .form-section:last-of-type {
                border-bottom: none;
            }

            .section-title {
                font-size: 1.5rem;
                color: var(--light);
                margin-bottom: 1.5rem;
                padding-bottom: 0.5rem;
                border-bottom: 2px solid var(--primary);
                display: inline-block;
            }

            .form-row {
                display: grid;
                grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
                gap: 1.5rem;
                margin-bottom: 1.5rem;
            }

            .form-group {
                display: flex;
                flex-direction: column;
                gap: 0.5rem;
            }

            .form-group label {
                color: var(--light);
                font-weight: 500;
                font-size: 0.95rem;
            }

            .required::after {
                content: " *";
                color: #ef4444;
            }

            .optional::after {
                content: " (Optional)";
                color: var(--text-dark);
                font-weight: normal;
                font-size: 0.85rem;
            }

            .form-control {
                width: 100%;
                padding: 0.8rem 1rem;
                background: rgba(255, 255, 255, 0.05);
                border: 1px solid rgba(255, 255, 255, 0.1);
                border-radius: 8px;
                color: var(--text);
                font-size: 1rem;
                transition: all 0.3s ease;
            }

            .form-control:focus {
                outline: none;
                border-color: var(--primary);
                box-shadow: 0 0 0 2px rgba(59, 130, 246, 0.2);
            }

            .table-container {
                overflow-x: auto;
                margin-top: 1rem;
            }

            .form-table {
                width: 100%;
                border-collapse: collapse;
                margin-bottom: 1rem;
            }

            .form-table th {
                background: rgba(255, 255, 255, 0.05);
                color: var(--light);
                padding: 0.8rem;
                text-align: left;
                font-weight: 600;
                border: 1px solid rgba(255, 255, 255, 0.1);
            }

            .form-table td {
                padding: 0.8rem;
                border: 1px solid rgba(255, 255, 255, 0.1);
            }

            .form-table input {
                width: 100%;
                padding: 0.5rem;
                background: rgba(255, 255, 255, 0.05);
                border: 1px solid rgba(151, 69, 69, 0.1);
                border-radius: 4px;
                color: var(--text);
                font-size: 0.9rem;
            }

            .form-table input:focus {
                outline: none;
                border-color: var(--primary);
            }

            .signature-area {
                margin-top: 2rem;
                padding-top: 1rem;
                border-top: 1px solid rgba(255, 255, 255, 0.1);
            }

            .signature-field {
                width: 100%;
                height: 100px;
                background: rgba(255, 255, 255, 0.05);
                border: 1px dashed rgba(3, 0, 0, 0.2);
                border-radius: 8px;
                margin-top: 1rem;
                display: flex;
                align-items: center;
                justify-content: center;
                color: var(--text-dark);
                cursor: pointer;
                transition: all 0.3s ease;
            }

            .signature-field:hover {
                background: rgba(255, 255, 255, 0.08);
                border-color: var(--primary);
            }

            .form-actions {
                display: flex;
                justify-content: space-between;
                margin-top: 2rem;
                gap: 1rem;
            }

            .btn-submit {
                background: var(--primary);
                color: white;
                border: none;
                padding: 1rem 2rem;
                border-radius: 8px;
                font-weight: 600;
                cursor: pointer;
                transition: all 0.3s ease;
            font-size: 1rem;
            flex: 1;
        }

        .btn-submit:hover {
            background: var(--secondary);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(59, 130, 246, 0.4);
        }

        .btn-reset {
            background: transparent;
            color: var(--text);
            border: 1px solid rgba(255, 255, 255, 0.2);
            padding: 1rem 2rem;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            font-size: 1rem;
            flex: 1;
        }

        .btn-reset:hover {
            background: rgba(255, 255, 255, 0.05);
            border-color: var(--text-dark);
        }

        /* Footer */
        footer {
            background: var(--footer-bg);
            color: var(--text);
            padding: 2rem 0 1rem;
            border-top: 1px solid rgba(255, 255, 255, 0.05);
            margin-top: auto;
            transition: background 0.3s ease;
        }

        .footer-content {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 2rem;
            margin-bottom: 2rem;
        }

        .footer-column h3 {
            font-size: 1.2rem;
            margin-bottom: 1rem;
            position: relative;
            padding-bottom: 10px;
            color: var(--light);
        }

        .footer-column h3::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 40px;
            height: 3px;
            background: var(--primary);
        }

        .footer-links {
            list-style: none;
        }

        .footer-links li {
            margin-bottom: 0.8rem;
        }

        .footer-links a {
            color: var(--text-dark);
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .footer-links a:hover {
            color: var(--light);
            padding-left: 5px;
        }

        .social-links {
            display: flex;
            gap: 1rem;
            margin-top: 1rem;
        }

        .social-links a {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.05);
            border-radius: 50%;
            color: var(--text);
            transition: all 0.3s ease;
        }

        .social-links a:hover {
            background: var(--primary);
            color: white;
            transform: translateY(-3px);
        }

        .footer-bottom {
            text-align: center;
            padding-top: 1.5rem;
            border-top: 1px solid rgba(255, 255, 255, 0.05);
            color: var(--text-dark);
            font-size: 0.9rem;
        }

        /* Animations */
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        @keyframes slideUp {
            from { 
                opacity: 0;
                transform: translateY(30px);
            }
            to { 
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Responsive Design */
       
    </style>
</head>
<body>
      <!-- Header -->
<?php  include 'header.php'; ?>

    <!-- Application Form Section -->
    <section class="application-section">
        <div class="container">
            <div class="application-container">
                <div class="application-header">
                    <h1>Job Application Form</h1>
                    <p>Complete this form to apply for your desired position</p>
                </div>
                
                <div class="application-form-container">
                    <div class="form-note">
                        <p><strong>NOTE:</strong> Read the form carefully and write all the information correctly. In case of entering wrong information your application may be rejected.</p>
                    </div>
                    
                  <!-- <form id="jobApplicationForm"> -->
    <form id="jobApplicationForm" action="apply.php" method="POST">


    <!-- Job Information Section -->
    <div class="form-section">
        <h2 class="section-title">Job Information</h2>
        <div class="form-row">
            <div class="form-group">
                <label for="position" class="required">Position you are applying for:</label>
                <input type="text" id="position" name="position_applied" class="form-control" placeholder="Enter position" required>
            </div>
            <div class="form-group">
                <label for="salary" class="required">Desired Salary (Rs.):</label>
                <input type="number" id="salary" name="desired_salary" class="form-control" placeholder="Enter desired salary" required>
            </div>
        </div>
        <!-- <div class="form-row">
            <div class="form-group">
                <label for="available-date" class="required">Date Available for Work:</label>
                <input type="date" id="available-date" name="date_available" class="form-control" required>
            </div>
            <div class="form-group">
                <label for="current-position" class="optional">Current Position of Job:</label>
                <input type="text" id="current-position" name="current_position" class="form-control" placeholder="Enter current position">
            </div>
        </div> -->
        <div class="form-row">
            <div class="form-group">
                <label for="nic" class="required">CNIC #:</label>
                <input type="text" id="nic" name="nic_number" class="form-control" placeholder="Enter CNIC number" required>
            </div>
            <div class="form-group">
                <label for="desired-city" class="required">Desired City for Job:</label>
                <input type="text" id="desired-city" name="desired_city" class="form-control" placeholder="Enter desired city" required>
            </div>
        </div>
    </div>

    <!-- Personal Information Section -->
    <div class="form-section">
        <h2 class="section-title">Personal Information</h2>
        <div class="form-row">
            <div class="form-group">
                <label for="full-name" class="required">Applicant Full Name:</label>
                <input type="text" id="full-name" name="applicant_name" class="form-control" placeholder="Enter full name" required>
            </div>
            <div class="form-group">
                <label for="father-husband-name" class="required">Father's Name / Husband's Name:</label>
                <input type="text" id="father-husband-name" name="father_or_husband_name" class="form-control" placeholder="Enter name" required>
            </div>
        </div>
     
        <div class="form-row">
            <div class="form-group">
                <label for="current-address" class="required">Current Address:</label>
                <textarea id="current-address" name="current_address" class="form-control" rows="2" placeholder="Enter current address" required></textarea>
            </div>
            <div class="form-group">
                <label for="permanent-address" class="optional">Permanent Address:</label>
                <textarea id="permanent-address" name="permanent_address" class="form-control" rows="2" placeholder="Enter permanent address"></textarea>
            </div>
        </div>
        <div class="form-row">
            <div class="form-group">
                <label for="city-district" class="optional">City / District:</label>
                <input type="text" id="city-district" name="city_district" class="form-control" placeholder="Enter city/district">
            </div>
            <div class="form-group">
                <label for="total-experience" class="optional">Total Experience:</label>
                <input type="text" id="total-experience" name="total_experience" class="form-control" placeholder="Enter total experience">
            </div>
        </div>
        <div class="form-row">
            <div class="form-group">
                <label for="home-phone" class="optional">Home Phone:</label>
                <input type="tel" id="home-phone" name="home_phone" class="form-control" placeholder="Enter home phone">
            </div>
            <div class="form-group">
                <label for="cell-phone" class="optional">Cell Phone:</label>
                <input type="tel" id="cell-phone" name="cell_phone" class="form-control" placeholder="Enter cell phone">
            </div>
        </div>
        <div class="form-row">
            <div class="form-group">
                <label for="email" class="optional">Email:</label>
                <input type="email" id="email" name="email" class="form-control" placeholder="Enter email">
            </div>
            <div class="form-group">
                <label for="whatsapp" class="required">WhatsApp No:</label>
                <input type="tel" id="whatsapp" name="whatsapp_no" class="form-control" placeholder="Enter WhatsApp number" required>
            </div>
        </div>
    </div>

    <!-- Education Section -->
    <div class="form-section">
        <h2 class="section-title">Education</h2>
        <div class="table-container">
            <table class="form-table">
                <thead>
                    <tr>
                        <th>Degree / Certificate</th>
                        <th>Year Passed</th>
                        <th>Division</th>
                        <th>Board / University</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><input type="text" name="degree" placeholder="Degree/Certificate"></td>
                        <td><input type="text" name="year_passed" placeholder="Year"></td>
                        <td><input type="text" name="division" placeholder="Division"></td>
                        <td><input type="text" name="board" placeholder="Board/University"></td>
                    </tr>
                  
                </tbody>
            </table>
        </div>
    </div>

    <!-- Working Experience Section -->
    <div class="form-section">
        <h2 class="section-title">Working Experience</h2>
        <div class="table-container">
            <table class="form-table">
                <thead>
                    <tr>
                        <th>Company Name</th>
                        <th>Position of Job</th>
                        <th>Main Duty</th>
                        <th>Duration of Duty</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><input type="text" name="company_name" placeholder="Company name"></td>
                        <td><input type="text" name="position_of_job" placeholder="Position"></td>
                        <td><input type="text" name="main_duty1" placeholder="Main duty"></td>
                        <td><input type="text" name="duration_of_duty" placeholder="From - To"></td>
                    </tr>
                   
                </tbody>
            </table>
        </div>
    </div>

   

    <!-- Form Actions -->
    <div class="form-actions">
        <button type="reset" class="btn-reset">Reset Form</button>
        <button type="submit" class="btn-submit">Submit Application</button>
    </div>
</form>

                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
   <?php  include 'footer.php'; ?>

    <script>
        // Theme Toggle Functionality
        const themeToggle = document.getElementById('themeToggle');
        const prefersDarkScheme = window.matchMedia('(prefers-color-scheme: dark)');
        
        // Check for saved theme preference or use device preference
        const currentTheme = localStorage.getItem('theme') || 
                            (prefersDarkScheme.matches ? 'dark' : 'light');
        
        // Set initial theme
        document.documentElement.setAttribute('data-theme', currentTheme);
        
        // Toggle theme on button click
        themeToggle.addEventListener('click', function() {
            const currentTheme = document.documentElement.getAttribute('data-theme');
            const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
            
            document.documentElement.setAttribute('data-theme', newTheme);
            localStorage.setItem('theme', newTheme);
        });

        // Form Submission
        // const jobApplicationForm = document.getElementById('jobApplicationForm');
        // jobApplicationForm.addEventListener('submit', function(e) {
        //     e.preventDefault();
            
        //     // Get form values for validation
        //     const position = document.getElementById('position').value;
        //     const salary = document.getElementById('salary').value;
        //     const nic = document.getElementById('nic').value;
        //     const fullName = document.getElementById('full-name').value;
        //     const fatherHusbandName = document.getElementById('father-husband-name').value;
        //     const height = document.getElementById('height').value;
        //     const weight = document.getElementById('weight').value;
        //     const currentAddress = document.getElementById('current-address').value;
        //     const whatsapp = document.getElementById('whatsapp').value;
            
        //     // Simple validation for required fields
        //     if (!position || !salary || !nic || !fullName || !fatherHusbandName || 
        //         !height || !weight || !currentAddress || !whatsapp) {
        //         alert('Please fill in all required fields marked with *.');
        //         return;
        //     }
            
        //     // Show success message (in a real app, this would be an API call)
        //     alert(`Thank you, ${fullName}! Your application for the ${position} position has been submitted successfully.`);
            
        //     // In a real application, you would submit the form data to a server
        //     // and potentially redirect to a confirmation page
        // });

        // Signature Field Interaction
        const signatureField = document.getElementById('signatureField');
        signatureField.addEventListener('click', function() {
            alert('In a real application, this would open a signature pad or allow you to upload a signature image.');
            signatureField.innerHTML = '<span>Signature added</span>';
            signatureField.style.background = 'rgba(16, 185, 129, 0.1)';
            signatureField.style.borderColor = 'var(--success)';
        });

        // Simple animation on scroll
        document.addEventListener('DOMContentLoaded', function() {
            const animatedElements = document.querySelectorAll('.application-header, .application-form-container');
            
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.style.opacity = '1';
                        entry.target.style.transform = 'translateY(0)';
                    }
                });
            }, { threshold: 0.1 });
            
            animatedElements.forEach(el => {
                el.style.opacity = '0';
                el.style.transform = 'translateY(20px)';
                el.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
                observer.observe(el);
            });
        });
    </script>
</body>
</html>