<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>FOODMATE - Recovery Report</title>

  <!-- Font: Inter -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;800&display=swap" rel="stylesheet">

  <!-- Icons -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">

  <!-- Stylesheet -->
  <link rel="stylesheet" href="../CSS/recoveryreport.css" />
</head>

<body>
       <div class="app" id="app">
        <!-- Sidebar -->
        <aside class="sidebar" id="sidebar" aria-label="Sidebar Navigation">
            <!-- Mobile close arrow -->
            <button class="close-mobile" id="closeSidebarMobile" aria-label="Close sidebar" title="Close sidebar">
                <i class="fa-solid fa-arrow-left"></i>
            </button>
            <div class="brand">
                <div class="logo"><i class="fa-solid fa-users"></i></div>
                <div class="title"><span>CUSTOMER</span> Management</div>
            </div>
            <nav class="nav" id="nav">
                <ul class="nav-group">
          <!-- 0. Dashboard -->
          <li class="nav-item">
            <a class="link has-tooltip" href="index.php" data-page="Dashboard">
              <span class="icon"><i class="fa-solid fa-house"></i></span>
              <span class="text">Dashboard</span>
              <span class="tooltip">Dashboard</span>
            </a>
          </li>
          <!-- 1. Customer Management (Dropdown) -->
          <li class="nav-item">
            <button class="link has-tooltip" data-toggle="submenu" aria-expanded="false">
              <span class="icon"><i class="fa-solid fa-users"></i></span>
              <span class="text">Customer Management</span>
              <i class="fa-solid fa-chevron-down chev"></i>
              <span class="tooltip">Customer Management</span>
            </button>
            <div class="submenu">
              <!-- <a class="link has-tooltip" href="addcustomer.php" data-page="Add Customer">
                <i class="fa-solid fa-user-plus"></i>
                <span class="text">Add Customer</span>
                <span class="tooltip">Add Customer</span>
              </a> -->
               <a class="link has-tooltip" href="customerlist.php" data-page="Customer List">
                                <i class="fa-solid fa-list"></i>
                                <span class="text">Customer List</span>
                                <!-- <span class="tooltip">Customer List</span> -->
                            </a>
              <a class="link has-tooltip" href="postjob.php" data-page="Customer List">
                <i class="fa-solid fa-list"></i>
                <span class="text">Post Job</span>
                <span class="tooltip">Post Job</span>
              </a>
              <a class="link has-tooltip" href="applyjob.php" data-page="Customer List">
                  <i class="fa-solid fa-list"></i>
                  <span class="text">Apply Job</span>
                  <!-- <span class="tooltip">Customer List</span> -->
                </a>
            </div>
          </li>
          <!-- 2. Customer Renewal -->
          <li class="nav-item">
            <a class="link has-tooltip" href="customerrenewal.php" data-page="Customer Renewal">
              <span class="icon"><i class="fa-solid fa-rotate-right"></i></span>
              <span class="text">Customer Renewal</span>
              <span class="tooltip">Customer Renewal</span>
            </a>
          </li>
          <!-- 3. Renewal List -->
          <li class="nav-item">
            <a class="link has-tooltip" href="renewallist.php" data-page="Renewal List">
              <span class="icon"><i class="fa-solid fa-list-check"></i></span>
              <span class="text">Renewal List</span>
              <span class="tooltip">Renewal List</span>
            </a>
          </li>
          <!-- 4. Reports (Dropdown) -->
          <li class="nav-item">
            <button class="link has-tooltip active" data-toggle="submenu" aria-expanded="false">
              <span class="icon"><i class="fa-solid fa-chart-line"></i></span>
              <span class="text">Reports</span>
              <i class="fa-solid fa-chevron-down chev"></i>
              <span class="tooltip">Reports</span>
            </button>
            <div class="submenu">
              <a class="link has-tooltip active" href="recoveryreport.php" data-page="Recovery Report">
                <i class="fa-solid fa-rotate-left"></i>
                <span class="text">Recovery Report</span>
                <span class="tooltip">Recovery Report</span>
              </a>
              <a class="link has-tooltip" href="pendingreport.php" data-page="Pending Report">
                <i class="fa-solid fa-clock"></i>
                <span class="text">Pending Report</span>
                <span class="tooltip">Pending Report</span>
              </a>
              <a class="link has-tooltip" href="reports.php" data-page="General Reports">
                <i class="fa-solid fa-chart-bar"></i>
                <span class="text">General Reports</span>
                <span class="tooltip">General Reports</span>
              </a>
            </div>
          </li>
        </ul>
      </nav>
    </aside>

    <!-- Header -->
    <header class="header">
      <button class="toggle" id="sidebarToggle" aria-label="Toggle sidebar"><i class="fa-solid fa-bars"></i></button>
      <div class="title-wrap">
        <div class="title" id="pageTitle">Recovery Report</div>
        <div class="muted" id="headerInfo">Customer recovery analytics and performance metrics</div>
      </div>

      <div class="pill" id="clock"><i class="fa-regular fa-clock"></i> <span>--:--</span></div>
      <div class="search">
        <i class="fa-solid fa-magnifying-glass" aria-hidden="true"></i>
        <input type="text" placeholder="Search…" aria-label="Search">
        <kbd style="opacity:.6">/</kbd>
      </div>
      <button class="toggle" id="collapseToggle" aria-label="Collapse sidebar"><i
          class="fa-solid fa-grip-lines"></i></button>
      <div style="width:1px;height:28px;background:rgba(255,255,255,0.12);"></div>
      <i class="fa-regular fa-bell" style="font-size:20px;opacity:.9"></i>
      <div class="avatar" title="You" 
           style="width:40px; height:40px; display:flex; align-items:center; justify-content:center; border-radius:50%; background: var(--gradient);">
        <i class="fa-solid fa-user-tie" style="font-size:18px; color:#fcf7f7;"></i>
      </div>
    </header>

    <!-- Main -->
    <main class="main">
      <!-- Page Header -->
      <div class="page-header">
        <div>
          <h2 style="margin-bottom: 8px;">Customer Recovery Analytics</h2>
          <p style="color: var(--muted);">Track and analyze customer recovery efforts and success rates</p>
        </div>
        <div style="display: flex; gap: 12px;">
          <button class="btn btn-secondary" id="printReport">
            <i class="fa-solid fa-print"></i> Print Report
          </button>
          <button class="btn btn-primary" id="exportReport">
            <i class="fa-solid fa-file-export"></i> Export Report
          </button>
        </div>
      </div>

      <!-- Recovery Stats Cards -->
      <div class="stats-grid">
        <div class="stat-card">
          <div class="stat-icon primary">
            <i class="fa-solid fa-rotate-left"></i>
          </div>
          <div class="stat-content">
            <h3>156</h3>
            <p>Total Recovery Attempts</p>
          </div>
        </div>
        
        <div class="stat-card">
          <div class="stat-icon success">
            <i class="fa-solid fa-check-circle"></i>
          </div>
          <div class="stat-content">
            <h3>89</h3>
            <p>Successful Recoveries</p>
          </div>
        </div>
        
        <div class="stat-card">
          <div class="stat-icon warning">
            <i class="fa-solid fa-clock"></i>
          </div>
          <div class="stat-content">
            <h3>42</h3>
            <p>In Progress</p>
          </div>
        </div>
        
        <div class="stat-card">
          <div class="stat-icon info">
            <i class="fa-solid fa-percentage"></i>
          </div>
          <div class="stat-content">
            <h3>57%</h3>
            <p>Recovery Rate</p>
          </div>
        </div>
      </div>

      <!-- Performance Chart -->
      <div class="chart-container">
        <div class="chart-header">
          <h3 style="font-weight: 600;">Recovery Performance Trend</h3>
          <div class="chart-actions">
            <select class="filter-select" style="width: 150px;">
              <option>Last 7 Days</option>
              <option>Last 30 Days</option>
              <option>Last 90 Days</option>
              <option>This Year</option>
            </select>
          </div>
        </div>
        <div class="chart-placeholder">
          <div style="text-align: center;">
            <i class="fa-solid fa-chart-line" style="font-size: 48px; margin-bottom: 16px; opacity: 0.5;"></i>
            <div>Recovery Performance Chart</div>
            <div style="font-size: 14px; margin-top: 8px;">Visualization of recovery success rates over time</div>
          </div>
        </div>
      </div>

      <!-- Filter Section -->
      <div class="filter-section">
        <h3 style="margin-bottom: 16px; font-weight: 600;">Filter Recovery Data</h3>
        <div class="filter-grid">
          <div class="filter-group">
            <label class="filter-label">Recovery Status</label>
            <select class="filter-select" id="statusFilter">
              <option value="">All Status</option>
              <option value="recovered">Recovered</option>
              <option value="in-progress">In Progress</option>
              <option value="failed">Failed</option>
              <option value="pending">Pending</option>
            </select>
          </div>
          <div class="filter-group">
            <label class="filter-label">Date Range</label>
            <select class="filter-select" id="dateFilter">
              <option value="">All Time</option>
              <option value="today">Today</option>
              <option value="week">This Week</option>
              <option value="month">This Month</option>
              <option value="quarter">This Quarter</option>
            </select>
          </div>
          <div class="filter-group">
            <label class="filter-label">Recovery Agent</label>
            <select class="filter-select" id="agentFilter">
              <option value="">All Agents</option>
              <option value="agent1">Agent 1</option>
              <option value="agent2">Agent 2</option>
              <option value="agent3">Agent 3</option>
            </select>
          </div>
          <div class="filter-group">
            <button class="btn btn-secondary" id="applyFilters">
              <i class="fa-solid fa-filter"></i> Apply Filters
            </button>
          </div>
        </div>
      </div>

      <!-- Recovery Table -->
      <div class="table-container">
        <div class="table-header">
          <h3 style="font-weight: 600;">Recovery Attempts</h3>
          <div class="table-actions">
            <div class="table-search">
              <i class="fa-solid fa-magnifying-glass" aria-hidden="true"></i>
              <input type="text" placeholder="Search recoveries…" id="tableSearch">
            </div>
            <button class="btn btn-sm btn-secondary" id="clearFilters">
              <i class="fa-solid fa-rotate-left"></i> Clear Filters
            </button>
          </div>
        </div>
        
        <div style="overflow-x: auto;">
          <table>
            <thead>
              <tr>
                <th>Recovery ID</th>
                <th>Customer</th>
                <th>Recovery Agent</th>
                <th>Attempt Date</th>
                <th>Recovery Method</th>
                <th>Amount Recovered</th>
                <th>Status</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody id="recoveryTable">
              <!-- Recovery data will be populated by JavaScript -->
            </tbody>
          </table>
        </div>
        
        <div class="pagination">
          <div class="pagination-info">Showing 1-10 of 156 recovery attempts</div>
          <div class="pagination-controls">
            <button class="page-btn"><i class="fa-solid fa-chevron-left"></i></button>
            <button class="page-btn active">1</button>
            <button class="page-btn">2</button>
            <button class="page-btn">3</button>
            <button class="page-btn">4</button>
            <button class="page-btn">5</button>
            <button class="page-btn"><i class="fa-solid fa-chevron-right"></i></button>
          </div>
        </div>
      </div>

      <!-- Recovery Insights -->
      <div class="grid">
        <section class="card" style="grid-column: span 6;">
          <h3 style="margin-bottom: 16px; font-weight: 600;">Top Recovery Reasons</h3>
          <div class="recovery-reasons">
            <div class="reason-item">
              <span>Payment Issues</span>
              <span style="font-weight: 600; color: var(--primary);">42%</span>
            </div>
            <div class="reason-item">
              <span>Service Dissatisfaction</span>
              <span style="font-weight: 600; color: var(--primary);">28%</span>
            </div>
            <div class="reason-item">
              <span>Technical Problems</span>
              <span style="font-weight: 600; color: var(--primary);">15%</span>
            </div>
            <div class="reason-item">
              <span>Competitor Switch</span>
              <span style="font-weight: 600; color: var(--primary);">8%</span>
            </div>
            <div class="reason-item">
              <span>Other Reasons</span>
              <span style="font-weight: 600; color: var(--primary);">7%</span>
            </div>
          </div>
        </section>

        <section class="card" style="grid-column: span 6;">
          <h3 style="margin-bottom: 16px; font-weight: 600;">Recovery Performance</h3>
          <div class="recovery-stats">
            <div class="recovery-stat-card">
              <h4>Email Campaigns</h4>
              <div class="value successful-recovery">32%</div>
              <div style="font-size: 12px; color: var(--muted);">Success Rate</div>
            </div>
            <div class="recovery-stat-card">
              <h4>Phone Calls</h4>
              <div class="value successful-recovery">68%</div>
              <div style="font-size: 12px; color: var(--muted);">Success Rate</div>
            </div>
            <div class="recovery-stat-card">
              <h4>Special Offers</h4>
              <div class="value successful-recovery">45%</div>
              <div style="font-size: 12px; color: var(--muted);">Success Rate</div>
            </div>
          </div>
        </section>
      </div>
      
      <div style="text-align: center; margin-top: 30px;" class="footer">© <span id="year"></span> FOODMATE Created by <span title="love"
                    style="color:var(--secondary); ">IT Genesis</span></div>
    </main>
  </div>
  
  <script src="../JS/recoveryreport.js"></script>
</body>

</html>