<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>FOODMATE - Pending Report</title>

  <!-- Font: Inter -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;800&display=swap" rel="stylesheet">

  <!-- Icons -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">

  <!-- Stylesheet -->
  <link rel="stylesheet" href="../CSS/pendingreport.css" />
</head>

<body>
   <div class="app" id="app">
        <!-- Sidebar -->
        <aside class="sidebar" id="sidebar" aria-label="Sidebar Navigation">
            <!-- Mobile close arrow -->
            <button class="close-mobile" id="closeSidebarMobile" aria-label="Close sidebar" title="Close sidebar">
                <i class="fa-solid fa-arrow-left"></i>
            </button>
            <div class="brand">
                <div class="logo"><i class="fa-solid fa-users"></i></div>
                <div class="title"><span>CUSTOMER</span> Management</div>
            </div>
            <nav class="nav" id="nav">
                <ul class="nav-group">
          <!-- 0. Dashboard -->
          <li class="nav-item">
            <a class="link has-tooltip" href="index.php" data-page="Dashboard">
              <span class="icon"><i class="fa-solid fa-house"></i></span>
              <span class="text">Dashboard</span>
              <span class="tooltip">Dashboard</span>
            </a>
          </li>
          <!-- 1. Customer Management (Dropdown) -->
          <li class="nav-item">
            <button class="link has-tooltip" data-toggle="submenu" aria-expanded="false">
              <span class="icon"><i class="fa-solid fa-users"></i></span>
              <span class="text">Customer Management</span>
              <i class="fa-solid fa-chevron-down chev"></i>
              <span class="tooltip">Customer Management</span>
            </button>
            <div class="submenu">
              <!-- <a class="link has-tooltip" href="addcustomer.php" data-page="Add Customer">
                <i class="fa-solid fa-user-plus"></i>
                <span class="text">Add Customer</span>
                <span class="tooltip">Add Customer</span>
              </a> -->
               <a class="link has-tooltip" href="customerlist.php" data-page="Customer List">
                                <i class="fa-solid fa-list"></i>
                                <span class="text">Customer List</span>
                                <!-- <span class="tooltip">Customer List</span> -->
                            </a>
              <a class="link has-tooltip" href="postjob.php" data-page="Customer List">
                <i class="fa-solid fa-list"></i>
                <span class="text">Post Job</span>
                <span class="tooltip">Post Job</span>
              </a>
              <a class="link has-tooltip" href="applyjob.php" data-page="Customer List">
                  <i class="fa-solid fa-list"></i>
                  <span class="text">Apply Job</span>
                  <!-- <span class="tooltip">Customer List</span> -->
                </a>
            </div>
          </li>
          <!-- 2. Customer Renewal -->
          <li class="nav-item">
            <a class="link has-tooltip" href="customerrenewal.php" data-page="Customer Renewal">
              <span class="icon"><i class="fa-solid fa-rotate-right"></i></span>
              <span class="text">Customer Renewal</span>
              <span class="tooltip">Customer Renewal</span>
            </a>
          </li>
          <!-- 3. Renewal List -->
          <li class="nav-item">
            <a class="link has-tooltip" href="renewallist.php" data-page="Renewal List">
              <span class="icon"><i class="fa-solid fa-list-check"></i></span>
              <span class="text">Renewal List</span>
              <span class="tooltip">Renewal List</span>
            </a>
          </li>
          <!-- 4. Reports (Dropdown) -->
          <li class="nav-item">
            <button class="link has-tooltip active" data-toggle="submenu" aria-expanded="false">
              <span class="icon"><i class="fa-solid fa-chart-line"></i></span>
              <span class="text">Reports</span>
              <i class="fa-solid fa-chevron-down chev"></i>
              <span class="tooltip">Reports</span>
            </button>
            <div class="submenu">
              <a class="link has-tooltip" href="recoveryreport.php" data-page="Recovery Report">
                <i class="fa-solid fa-rotate-left"></i>
                <span class="text">Recovery Report</span>
                <span class="tooltip">Recovery Report</span>
              </a>
              <a class="link has-tooltip active" href="pendingreport.php" data-page="Pending Report">
                <i class="fa-solid fa-clock"></i>
                <span class="text">Pending Report</span>
                <span class="tooltip">Pending Report</span>
              </a>
              <a class="link has-tooltip" href="reports.php" data-page="General Reports">
                <i class="fa-solid fa-chart-bar"></i>
                <span class="text">General Reports</span>
                <span class="tooltip">General Reports</span>
              </a>
            </div>
          </li>
        </ul>
      </nav>
    </aside>

    <!-- Header -->
    <header class="header">
      <button class="toggle" id="sidebarToggle" aria-label="Toggle sidebar"><i class="fa-solid fa-bars"></i></button>
      <div class="title-wrap">
        <div class="title" id="pageTitle">Pending Report</div>
        <div class="muted" id="headerInfo">Monitor and manage all pending actions and approvals</div>
      </div>

      <div class="pill" id="clock"><i class="fa-regular fa-clock"></i> <span>--:--</span></div>
      <div class="search">
        <i class="fa-solid fa-magnifying-glass" aria-hidden="true"></i>
        <input type="text" placeholder="Search…" aria-label="Search">
        <kbd style="opacity:.6">/</kbd>
      </div>
      <button class="toggle" id="collapseToggle" aria-label="Collapse sidebar"><i
          class="fa-solid fa-grip-lines"></i></button>
      <div style="width:1px;height:28px;background:rgba(255,255,255,0.12);"></div>
      <i class="fa-regular fa-bell" style="font-size:20px;opacity:.9"></i>
      <div class="avatar" title="You" 
           style="width:40px; height:40px; display:flex; align-items:center; justify-content:center; border-radius:50%; background: var(--gradient);">
        <i class="fa-solid fa-user-tie" style="font-size:18px; color:#fcf7f7;"></i>
      </div>
    </header>

    <!-- Main -->
    <main class="main">
      <!-- Page Header -->
      <div class="page-header">
        <div>
          <h2 style="margin-bottom: 8px;">Pending Actions Dashboard</h2>
          <p style="color: var(--muted);">Track and manage all pending approvals, renewals, and actions</p>
        </div>
        <div style="display: flex; gap: 12px;">
          <button class="btn btn-secondary" id="printReport">
            <i class="fa-solid fa-print"></i> Print Report
          </button>
          <button class="btn btn-primary" id="exportReport">
            <i class="fa-solid fa-file-export"></i> Export Report
          </button>
        </div>
      </div>

      <!-- Pending Stats Cards -->
      <div class="stats-grid">
        <div class="stat-card">
          <div class="stat-icon warning">
            <i class="fa-solid fa-clock"></i>
          </div>
          <div class="stat-content">
            <h3>142</h3>
            <p>Total Pending Items</p>
          </div>
        </div>
        
        <div class="stat-card">
          <div class="stat-icon danger">
            <i class="fa-solid fa-exclamation-triangle"></i>
          </div>
          <div class="stat-content">
            <h3>28</h3>
            <p>Overdue Actions</p>
          </div>
        </div>
        
        <div class="stat-card">
          <div class="stat-icon primary">
            <i class="fa-solid fa-user-check"></i>
          </div>
          <div class="stat-content">
            <h3>64</h3>
            <p>Awaiting Approval</p>
          </div>
        </div>
        
        <div class="stat-card">
          <div class="stat-icon info">
            <i class="fa-solid fa-list-check"></i>
          </div>
          <div class="stat-content">
            <h3>89</h3>
            <p>Pending Renewals</p>
          </div>
        </div>
      </div>

      <!-- Performance Chart -->
      <div class="chart-container">
        <div class="chart-header">
          <h3 style="font-weight: 600;">Pending Items Trend</h3>
          <div class="chart-actions">
            <select class="filter-select" style="width: 150px;">
              <option>Last 7 Days</option>
              <option>Last 30 Days</option>
              <option>Last 90 Days</option>
              <option>This Year</option>
            </select>
          </div>
        </div>
        <div class="chart-placeholder">
          <div style="text-align: center;">
            <i class="fa-solid fa-chart-bar" style="font-size: 48px; margin-bottom: 16px; opacity: 0.5;"></i>
            <div>Pending Items Overview</div>
            <div style="font-size: 14px; margin-top: 8px;">Visualization of pending items by category and status</div>
          </div>
        </div>
      </div>

      <!-- Filter Section -->
      <div class="filter-section">
        <h3 style="margin-bottom: 16px; font-weight: 600;">Filter Pending Items</h3>
        <div class="filter-grid">
          <div class="filter-group">
            <label class="filter-label">Item Type</label>
            <select class="filter-select" id="typeFilter">
              <option value="">All Types</option>
              <option value="renewal">Renewals</option>
              <option value="approval">Approvals</option>
              <option value="payment">Payments</option>
              <option value="document">Documents</option>
              <option value="support">Support Tickets</option>
            </select>
          </div>
          <div class="filter-group">
            <label class="filter-label">Status</label>
            <select class="filter-select" id="statusFilter">
              <option value="">All Status</option>
              <option value="pending">Pending</option>
              <option value="overdue">Overdue</option>
              <option value="in-review">In Review</option>
              <option value="awaiting-approval">Awaiting Approval</option>
            </select>
          </div>
          <div class="filter-group">
            <label class="filter-label">Priority</label>
            <select class="filter-select" id="priorityFilter">
              <option value="">All Priorities</option>
              <option value="high">High</option>
              <option value="medium">Medium</option>
              <option value="low">Low</option>
            </select>
          </div>
          <div class="filter-group">
            <button class="btn btn-secondary" id="applyFilters">
              <i class="fa-solid fa-filter"></i> Apply Filters
            </button>
          </div>
        </div>
      </div>

      <!-- Pending Table -->
      <div class="table-container">
        <div class="table-header">
          <h3 style="font-weight: 600;">Pending Items</h3>
          <div class="table-actions">
            <div class="table-search">
              <i class="fa-solid fa-magnifying-glass" aria-hidden="true"></i>
              <input type="text" placeholder="Search pending items…" id="tableSearch">
            </div>
            <button class="btn btn-sm btn-secondary" id="clearFilters">
              <i class="fa-solid fa-rotate-left"></i> Clear Filters
            </button>
          </div>
        </div>
        
        <div style="overflow-x: auto;">
          <table>
            <thead>
              <tr>
                <th>Item ID</th>
                <th>Customer</th>
                <th>Item Type</th>
                <th>Created Date</th>
                <th>Due Date</th>
                <th>Priority</th>
                <th>Status</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody id="pendingTable">
              <!-- Pending data will be populated by JavaScript -->
            </tbody>
          </table>
        </div>
        
        <div class="pagination">
          <div class="pagination-info">Showing 1-10 of 142 pending items</div>
          <div class="pagination-controls">
            <button class="page-btn"><i class="fa-solid fa-chevron-left"></i></button>
            <button class="page-btn active">1</button>
            <button class="page-btn">2</button>
            <button class="page-btn">3</button>
            <button class="page-btn">4</button>
            <button class="page-btn">5</button>
            <button class="page-btn"><i class="fa-solid fa-chevron-right"></i></button>
          </div>
        </div>
      </div>

      <!-- Pending Insights -->
      <div class="grid">
        <section class="card" style="grid-column: span 6;">
          <h3 style="margin-bottom: 16px; font-weight: 600;">Pending Items by Category</h3>
          <div class="pending-reasons">
            <div class="reason-item">
              <span>Subscription Renewals</span>
              <span style="font-weight: 600; color: var(--primary);">42%</span>
            </div>
            <div class="reason-item">
              <span>Payment Approvals</span>
              <span style="font-weight: 600; color: var(--primary);">28%</span>
            </div>
            <div class="reason-item">
              <span>Document Verification</span>
              <span style="font-weight: 600; color: var(--primary);">15%</span>
            </div>
            <div class="reason-item">
              <span>Support Tickets</span>
              <span style="font-weight: 600; color: var(--primary);">8%</span>
            </div>
            <div class="reason-item">
              <span>Other Approvals</span>
              <span style="font-weight: 600; color: var(--primary);">7%</span>
            </div>
          </div>
        </section>

        <section class="card" style="grid-column: span 6;">
          <h3 style="margin-bottom: 16px; font-weight: 600;">Pending Items Overview</h3>
          <div class="pending-stats">
            <div class="pending-stat-card">
              <h4>High Priority</h4>
              <div class="value overdue-tasks">23</div>
              <div style="font-size: 12px; color: var(--muted);">Items</div>
            </div>
            <div class="pending-stat-card">
              <h4>Medium Priority</h4>
              <div class="value pending-renewals">67</div>
              <div style="font-size: 12px; color: var(--muted);">Items</div>
            </div>
            <div class="pending-stat-card">
              <h4>Low Priority</h4>
              <div class="value pending-reviews">52</div>
              <div style="font-size: 12px; color: var(--muted);">Items</div>
            </div>
          </div>
        </section>
      </div>
      
      <div style="text-align: center; margin-top: 30px;" class="footer">© <span id="year"></span> FOODMATE Created by <span title="love"
                    style="color:var(--secondary); ">IT Genesis</span></div>
    </main>
  </div>
  
  <script src="../JS/pendingreport.js"></script>
</body>

</html>