<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>FOODMATE Customer Management</title>
    <!-- Font: Inter -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap"
        rel="stylesheet">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">

    <!-- Icons: Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">
    <!-- Stylesheet -->
    <link rel="stylesheet" href="./CSS/index.css">
  <style>
    .app {
    display: grid;
    grid-template-columns: 280px auto;
    grid-template-rows: 72px auto;
    height: 100vh;
    /* overflow: ; */
}

.sidebar {
    grid-row: 1 / span 2;
    height: 100%;
    overflow-y: auto;
}



.main {
    grid-column: 2;
    overflow-y: auto;
    padding: 20px;
    background: #f7f8fc;
    height: calc(100vh - 70px);
}
</style>

</head>

<body>
    <div class="app" id="app">
        <!-- Sidebar -->
  <?php include 'asidebar.php'; ?>

        <!-- Header -->
      <?php include 'header.php';?>

        <!-- Main -->
        <main class="main" id="main">
            <div class="grid">
                <!-- KPIs -->
                <section class="card" style="grid-column: span 3;">
                    <div class="kpi">
                        <div class="icon" style="background: rgba(212,0,0,.2)"><i class="fa-solid fa-users"></i></div>
                        <div>
                            <div class="muted">Total Customers</div>
                            <div class="value" id="kpiCustomers">8,452</div>
                        </div>
                        <div class="trend up">+12.3%</div>
                    </div>
                </section>
                <section class="card" style="grid-column: span 3;">
                    <div class="kpi">
                        <div class="icon" style="background: rgba(255,165,0,.22)">
                            <i class="fa-solid fa-rotate-right"></i>
                        </div>
                        <div>
                            <div class="muted">Pending Renewal</div>
                            <div class="value" id="kpiRenewal">142</div>
                        </div>
                        <div class="trend down">-8.2%</div>
                    </div>
                </section>
                <section class="card" style="grid-column: span 3;">
                    <div class="kpi">
                        <div class="icon" style="background: rgba(199, 70, 70, 0.08)"><i class="fa-solid fa-rotate-left"></i>
                        </div>
                        <div>
                            <div class="muted">Recovered</div>
                            <div class="value" id="kpiRecovered">36</div>
                        </div>
                        <div class="trend up">+5.7%</div>
                    </div>
                </section>
                <section class="card" style="grid-column: span 3;">
                    <div class="kpi">
                        <div class="icon" style="background: rgba(123, 144, 238, 0.08)"><i class="fa-solid fa-repeat"></i>
                        </div>
                        <div>
                            <div class="muted">Repeat Rate</div>
                            <div class="value" id="kpiRepeat">68%</div>
                        </div>
                        <div class="trend up">+5.2%</div>
                    </div>
                </section>

                <!-- Chart & Table -->
                <section class="card" style="grid-column: span 7;">
                    <div class="section-title">Customer Growth vs Renewals</div>
                    <div class="bar-chart" id="barChart">
                        <!-- Bars are injected by JS for dynamic header info tie -->
                    </div>
                </section>

                <section class="card" style="grid-column: span 5;">
                    <div class="section-title">Renewal Statistics</div>
                    <div class="renewal-stats">
                        <div class="renewal-stat-card">
                            <h4>Pending Renewal</h4>
                            <div class="value pending-renewal">142</div>
                        </div>
                        <div class="renewal-stat-card">
                            <h4>Completed Renewal</h4>
                            <div class="value completed-renewal">89</div>
                        </div>
                        <div class="renewal-stat-card">
                            <h4>Recovery Rate</h4>
                            <div class="value recovery-renewal">25%</div>
                        </div>
                    </div>
                    <div class="renewal-reasons">
                        <div class="section-title" style="margin-top: 16px;">Top Renewal Categories</div>
                        <div class="reason-item">
                            <span>Monthly Subscriptions</span>
                            <span>64</span>
                        </div>
                        <div class="reason-item">
                            <span>Annual Contracts</span>
                            <span>42</span>
                        </div>
                        <div class="reason-item">
                            <span>Service Packages</span>
                            <span>28</span>
                        </div>
                        <div class="reason-item">
                            <span>Premium Upgrades</span>
                            <span>18</span>
                        </div>
                    </div>
                </section>

                <!-- Recent Customers Table -->
                <section class="card" style="grid-column: span 8;">
                    <div class="section-title">Recent Customers</div>
                    <div style="overflow:auto">
                        <table>
                            <thead>
                                <tr>
                                    <th>Customer ID</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody id="customersTbody">
                                <!-- Filled dynamically -->
                            </tbody>
                        </table>
                    </div>
                </section>

                <!-- Quick Actions -->
                <section class="card" style="grid-column: span 4;">
                    <div class="section-title">Quick Actions</div>
                    <div class="customer-actions">
                        <button onclick="window.location.href='addcustomer.php'">
                            <i class="fa-solid fa-user-plus"></i>
                            Add New Customer
                        </button>
                        <button onclick="window.location.href='customerrenewal.php'">
                            <i class="fa-solid fa-rotate-right"></i>
                            Process Renewal
                        </button>
                        <button onclick="window.location.href='renewallist.php'">
                            <i class="fa-solid fa-list-check"></i>
                            View Renewals
                        </button>
                        <button onclick="window.location.href='recoveryreport.php'">
                            <i class="fa-solid fa-file-export"></i>
                            Export Reports
                        </button>
                    </div>
                </section>
            </div>

            <div class="footer">© <span id="year"></span> FOODMATE Customer Management</div>
        </main>
    </div>


        
    <script src="./JS/index.js"></script>
</body>

</html>