
    // ===== Dynamic Header: Clock =====
    const clock = document.querySelector('#clock span');
    function pad(n) { return (n < 10 ? '0' : '') + n }
    function tick() {
      const d = new Date();
      const h = pad(d.getHours());
      const m = pad(d.getMinutes());
      clock.textContent = `${h}:${m}`;
    }
    setInterval(tick, 1000); tick();

    // ===== Sidebar: dropdowns =====
    const dropdownTriggers = [...document.querySelectorAll('[data-toggle="submenu"]')];
    dropdownTriggers.forEach(btn => {
      const item = btn.closest('.nav-item');
      const pane = item.querySelector('.submenu');
      btn.addEventListener('click', () => {
        const expanded = btn.getAttribute('aria-expanded') === 'true';
        btn.setAttribute('aria-expanded', String(!expanded));
        btn.classList.toggle('active', !expanded);
        pane.style.height = !expanded ? (pane.scrollHeight + 'px') : '0px';
        btn.querySelector('.chev').style.transform = !expanded ? 'rotate(180deg)' : 'rotate(0)';
      });
    });
    function closeSiblings(currentBtn) {
      dropdownTriggers.forEach(btn => {
        if (btn !== currentBtn) {
          const pane = btn.closest('.nav-item').querySelector('.submenu');
          btn.setAttribute('aria-expanded', 'false');
          btn.classList.remove('active');
          pane.style.height = '0px';
          btn.querySelector('.chev').style.transform = 'rotate(0)';
        }
      })
    }
    dropdownTriggers.forEach(btn => btn.addEventListener('click', () => closeSiblings(btn)));

    // ===== Sidebar: collapse & mobile toggle =====
    const app = document.getElementById('app');
    const sidebar = document.getElementById('sidebar');
    const sidebarToggle = document.getElementById('sidebarToggle');
    const collapseToggle = document.getElementById('collapseToggle');
    const closeSidebarMobile = document.getElementById('closeSidebarMobile');
    
    sidebarToggle.addEventListener('click', () => {
      if (window.matchMedia('(max-width: 860px)').matches) {
        sidebar.classList.toggle('open');
      } else {
        app.classList.toggle('collapsed');
      }
    });
    
    collapseToggle.addEventListener('click', () => {
      app.classList.toggle('collapsed');
    });
    
    closeSidebarMobile.addEventListener('click', () => {
      sidebar.classList.remove('open');
    });
    
    document.querySelector('.main').addEventListener('click', () => {
      if (window.matchMedia('(max-width: 860px)').matches) {
        sidebar.classList.remove('open');
      }
    });

    // ===== Keyboard shortcut for search focus =====
    const searchInput = document.querySelector('.header .search input');
    window.addEventListener('keydown', (e) => {
      if (e.key === '/' && document.activeElement !== searchInput) {
        e.preventDefault(); searchInput.focus();
      }
    });

    // ===== Set current year in footer =====
    document.getElementById('year').textContent = new Date().getFullYear();

    // ===== Sample Customer Data =====
    const customers = [
      {
        id: 'CUS-001',
        name: 'Ahmed Raza',
        company: 'Tech Solutions Ltd',
        phone: '+92 300 1234567',
        email: 'ahmed@techsolutions.com',
        services: ['Website', 'Domain'],
        jobDate: '2024-01-15',
        charges: 'Monthly',
        status: 'active',
        amount: 'PKR 15,000'
      },
      {
        id: 'CUS-002',
        name: 'Sana Khan',
        company: 'Digital Marketing Pro',
        phone: '+92 301 2345678',
        email: 'sana@dmp.com',
        services: ['Software', 'Hosting'],
        jobDate: '2024-01-20',
        charges: 'Quarterly',
        status: 'active',
        amount: 'PKR 45,000'
      },
      {
        id: 'CUS-003',
        name: 'Bilal Ahmed',
        company: 'Startup Innovations',
        phone: '+92 302 3456789',
        email: 'bilal@startup.com',
        services: ['Website'],
        jobDate: '2024-02-01',
        charges: 'Yearly',
        status: 'pending',
        amount: 'PKR 120,000'
      },
      {
        id: 'CUS-004',
        name: 'Hira Malik',
        company: 'E-commerce Store',
        phone: '+92 303 4567890',
        email: 'hira@estore.com',
        services: ['Domain', 'Hosting', 'Website'],
        jobDate: '2024-02-05',
        charges: 'Monthly',
        status: 'active',
        amount: 'PKR 25,000'
      },
      {
        id: 'CUS-005',
        name: 'Usman Ali',
        company: 'Consulting Firm',
        phone: '+92 304 5678901',
        email: 'usman@consulting.com',
        services: ['Software'],
        jobDate: '2024-02-10',
        charges: 'Quarterly',
        status: 'inactive',
        amount: 'PKR 60,000'
      },
      {
        id: 'CUS-006',
        name: 'Fatima Noor',
        company: 'Creative Agency',
        phone: '+92 305 6789012',
        email: 'fatima@creative.com',
        services: ['Website', 'Hosting'],
        jobDate: '2024-02-15',
        charges: 'Monthly',
        status: 'active',
        amount: 'PKR 18,000'
      },
      {
        id: 'CUS-007',
        name: 'Kamran Butt',
        company: 'Manufacturing Corp',
        phone: '+92 306 7890123',
        email: 'kamran@manufacturing.com',
        services: ['Software', 'Domain'],
        jobDate: '2024-02-20',
        charges: 'Yearly',
        status: 'pending',
        amount: 'PKR 200,000'
      },
      {
        id: 'CUS-008',
        name: 'Ayesha Siddiqui',
        company: 'Healthcare Solutions',
        phone: '+92 307 8901234',
        email: 'ayesha@healthcare.com',
        services: ['Website', 'Software'],
        jobDate: '2024-03-01',
        charges: 'Monthly',
        status: 'active',
        amount: 'PKR 22,000'
      },
      {
        id: 'CUS-009',
        name: 'Zain Abid',
        company: 'Real Estate Partners',
        phone: '+92 308 9012345',
        email: 'zain@realestate.com',
        services: ['Domain', 'Hosting'],
        jobDate: '2024-03-05',
        charges: 'Quarterly',
        status: 'inactive',
        amount: 'PKR 30,000'
      },
      {
        id: 'CUS-010',
        name: 'Nadia Shah',
        company: 'Education First',
        phone: '+92 309 0123456',
        email: 'nadia@education.com',
        services: ['Website', 'Software', 'Hosting'],
        jobDate: '2024-03-10',
        charges: 'Monthly',
        status: 'active',
        amount: 'PKR 28,000'
      }
    ];

    // ===== Populate Customer Table =====
    function populateCustomerTable() {
      const tableBody = document.getElementById('customersTable');
      tableBody.innerHTML = '';
      
      customers.forEach(customer => {
        const row = document.createElement('tr');
        
        // Get initials for avatar
        const initials = customer.name.split(' ').map(n => n[0]).join('').toUpperCase();
        
        // Format job date
        const jobDate = new Date(customer.jobDate).toLocaleDateString('en-US', {
          year: 'numeric',
          month: 'short',
          day: 'numeric'
        });
        
        row.innerHTML = `
          <td>
            <div style="display: flex; align-items: center; gap: 12px;">
              <div class="customer-avatar">${initials}</div>
              <div>
                <div style="font-weight: 600;">${customer.name}</div>
                <div style="font-size: 12px; color: var(--muted);">${customer.email}</div>
              </div>
            </div>
          </td>
          <td>${customer.company}</td>
          <td>${customer.phone}</td>
          <td>
            <div style="display: flex; flex-wrap: wrap; gap: 4px;">
              ${customer.services.map(service => 
                `<span style="background: rgba(212, 0, 0, 0.1); color: var(--primary); padding: 4px 8px; border-radius: 12px; font-size: 12px;">${service}</span>`
              ).join('')}
            </div>
          </td>
          <td>${jobDate}</td>
          <td>
            <div style="font-weight: 600;">${customer.charges}</div>
            <div style="font-size: 12px; color: var(--muted);">${customer.amount}</div>
          </td>
          <td>
            <span class="status ${customer.status}">${customer.status.charAt(0).toUpperCase() + customer.status.slice(1)}</span>
          </td>
          <td>
            <div class="action-buttons">
              <button class="action-btn view" title="View Details">
                <i class="fa-solid fa-eye"></i>
              </button>
              <button class="action-btn edit" title="Edit Customer">
                <i class="fa-solid fa-pen"></i>
              </button>
              <button class="action-btn delete" title="Delete Customer">
                <i class="fa-solid fa-trash"></i>
              </button>
            </div>
          </td>
        `;
        
        tableBody.appendChild(row);
      });
    }

    // ===== Table Search Functionality =====
    document.getElementById('tableSearch').addEventListener('input', function(e) {
      const searchTerm = e.target.value.toLowerCase();
      const rows = document.querySelectorAll('#customersTable tr');
      
      rows.forEach(row => {
        const text = row.textContent.toLowerCase();
        row.style.display = text.includes(searchTerm) ? '' : 'none';
      });
    });

    // ===== Action Button Handlers =====
    document.addEventListener('click', function(e) {
      if (e.target.closest('.action-btn.view')) {
        alert('View customer details - This would open a detailed view in a real application');
      }
      
      if (e.target.closest('.action-btn.edit')) {
        alert('Edit customer - This would open the edit form in a real application');
      }
      
      if (e.target.closest('.action-btn.delete')) {
        if (confirm('Are you sure you want to delete this customer?')) {
          alert('Customer deleted - This would remove the customer in a real application');
        }
      }
    });

    // ===== Pagination Controls =====
    document.querySelectorAll('.page-btn').forEach(btn => {
      btn.addEventListener('click', function() {
        if (!this.querySelector('i')) { // Don't change active state for arrow buttons
          document.querySelectorAll('.page-btn').forEach(b => b.classList.remove('active'));
          this.classList.add('active');
        }
      });
    });

    // ===== Initialize the page =====
    document.addEventListener('DOMContentLoaded', function() {
      // Set current page as active in sidebar
      const currentPage = 'customerlist.html';
      document.querySelectorAll('.nav a').forEach(link => {
        if (link.getAttribute('href') === currentPage) {
          link.classList.add('active');
          // If it's in a submenu, open the parent dropdown
          const parentItem = link.closest('.nav-item');
          if (parentItem) {
            const dropdownBtn = parentItem.querySelector('[data-toggle="submenu"]');
            if (dropdownBtn) {
              dropdownBtn.click(); // Open the dropdown
            }
          }
        }
      });
      
      // Populate the customer table
      populateCustomerTable();
    });







