

    // ===== Dynamic Header: Clock & Info =====
    const clock = document.querySelector('#clock span');
    const headerInfo = document.getElementById('headerInfo');
    function pad(n){ return (n<10? '0':'') + n }
    function tick(){
      const d = new Date();
      const h = pad(d.getHours());
      const m = pad(d.getMinutes());
      clock.textContent = `${h}:${m}`;
    }
    setInterval(tick, 1000); tick();
    headerInfo.textContent = 'Create new customer account';
    document.getElementById('year').textContent = new Date().getFullYear();

    // ===== Sidebar: dropdowns =====
    const dropdownTriggers = [...document.querySelectorAll('[data-toggle="submenu"]')];
    dropdownTriggers.forEach(btn => {
      const item = btn.closest('.nav-item');
      const pane = item.querySelector('.submenu');
      btn.addEventListener('click', () => {
        const expanded = btn.getAttribute('aria-expanded') === 'true';
        btn.setAttribute('aria-expanded', String(!expanded));
        btn.classList.toggle('active', !expanded);
        pane.style.height = !expanded ? (pane.scrollHeight + 'px') : '0px';
        btn.querySelector('.chev').style.transform = !expanded ? 'rotate(180deg)' : 'rotate(0)';
      });
    });

    // Close other dropdowns when opening one (optional polish)
    function closeSiblings(currentBtn){
      dropdownTriggers.forEach(btn => {
        if(btn!==currentBtn){
          const pane = btn.closest('.nav-item').querySelector('.submenu');
          btn.setAttribute('aria-expanded','false');
          btn.classList.remove('active');
          pane.style.height = '0px';
          btn.querySelector('.chev').style.transform = 'rotate(0)';
        }
      })
    }
    dropdownTriggers.forEach(btn => btn.addEventListener('click', () => closeSiblings(btn)));

   
    // ===== Sidebar: collapse & mobile toggle =====
    const app = document.getElementById('app');
    const sidebar = document.getElementById('sidebar');
    const sidebarToggle = document.getElementById('sidebarToggle');
    const collapseToggle = document.getElementById('collapseToggle');
    const closeSidebarMobile = document.getElementById('closeSidebarMobile');

    // Mobile open/close
    sidebarToggle.addEventListener('click', () => {
      if(window.matchMedia('(max-width: 860px)').matches){
        sidebar.classList.toggle('open');
      } else {
        app.classList.toggle('collapsed');
      }
    });

    // Collapse for wide screens
    collapseToggle.addEventListener('click', () => {
      app.classList.toggle('collapsed');
    });

    // Mobile close arrow
    closeSidebarMobile.addEventListener('click', () => {
      sidebar.classList.remove('open');
    });

    // Close mobile sidebar when clicking main area
    document.getElementById('main').addEventListener('click', () => {
      if(window.matchMedia('(max-width: 860px)').matches){
        sidebar.classList.remove('open');
      }
    })

    // ===== Keyboard shortcut for search focus =====
    const searchInput = document.querySelector('.header .search input');
    window.addEventListener('keydown', (e) => {
      if(e.key === '/' && document.activeElement !== searchInput){
        e.preventDefault(); searchInput.focus();
      }
    });

    // ===== Form Submission =====
    document.getElementById('saveBtn').addEventListener('click', function(e) {
      e.preventDefault();
      
      // Basic form validation
      const requiredFields = document.querySelectorAll('[required]');
      let isValid = true;
      
      requiredFields.forEach(field => {
        if (!field.value.trim()) {
          field.style.borderColor = 'var(--danger)';
          isValid = false;
        } else {
          field.style.borderColor = '#ddd';
        }
      });
      
      if (isValid) {
        // Show success message
        alert('Customer added successfully!');
        // In a real application, you would submit the form data to a server
        // window.location.href = 'customerlist.html';
      } else {
        alert('Please fill in all required fields.');
      }
    });

    // ===== Cancel Button =====
    document.getElementById('cancelBtn').addEventListener('click', function() {
      if (confirm('Are you sure you want to cancel? All unsaved changes will be lost.')) {
        window.location.href = 'customerlist.html';
      }
    });

    // ===== Initialize the page =====
    document.addEventListener('DOMContentLoaded', function() {
      // Set current page as active in sidebar
      const currentPage = 'addcustomer.html';
      document.querySelectorAll('.nav a').forEach(link => {
        if (link.getAttribute('href') === currentPage) {
          link.classList.add('active');
          // If it's in a submenu, open the parent dropdown
          const parentItem = link.closest('.nav-item');
          if (parentItem) {
            const dropdownBtn = parentItem.querySelector('[data-toggle="submenu"]');
            if (dropdownBtn) {
              dropdownBtn.click(); // Open the dropdown
            }
          }
        }
      });
      
      // Set today's date as default for start date
      const today = new Date().toISOString().split('T')[0];
      document.querySelector('input[type="date"]').value = today;
    });

    // Accessibility niceties: close dropdowns on Escape
    window.addEventListener('keydown', (e) => {
      if(e.key === 'Escape'){
        dropdownTriggers.forEach(btn => btn.click());
        sidebar.classList.remove('open');
      }
    });

    // Add event listeners to navigation items
    document.querySelectorAll('.nav a').forEach(link => {
      link.addEventListener('click', function(e) {
        // Update active state
        document.querySelectorAll('.nav a').forEach(a => a.classList.remove('active'));
        this.classList.add('active');
        
        // Update page content
        const page = this.getAttribute('data-page');
        document.getElementById('pageTitle').textContent = page;
      });
    });





